/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.jdt.internal.formatter.linewrap;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.greenrobot.eclipse.jdt.core.dom.ASTNode;
import org.greenrobot.eclipse.jdt.core.dom.Assignment;
import org.greenrobot.eclipse.jdt.core.dom.Block;
import org.greenrobot.eclipse.jdt.core.dom.BodyDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.ExpressionStatement;
import org.greenrobot.eclipse.jdt.core.dom.FieldDeclaration;
import org.greenrobot.eclipse.jdt.core.dom.Statement;
import org.greenrobot.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.greenrobot.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.greenrobot.eclipse.jdt.internal.formatter.DefaultCodeFormatterOptions;
import org.greenrobot.eclipse.jdt.internal.formatter.Token;
import org.greenrobot.eclipse.jdt.internal.formatter.TokenManager;
import org.greenrobot.eclipse.jdt.internal.formatter.TokenTraverser;

public class Aligner {
    private final List<List<? extends ASTNode>> alignGroups = new ArrayList<List<? extends ASTNode>>();
    private final DefaultCodeFormatterOptions options;
    final TokenManager tm;

    public Aligner(TokenManager tokenManager, DefaultCodeFormatterOptions options) {
        this.tm = tokenManager;
        this.options = options;
    }

    public void handleAlign(List<BodyDeclaration> bodyDeclarations) {
        if (!this.options.align_type_members_on_columns || this.areKeptOnOneLine(bodyDeclarations)) {
            return;
        }
        List fieldGroups = this.toAlignGroups(bodyDeclarations, n -> this.optionalCast((ASTNode)n, (Class)FieldDeclaration.class));
        this.alignGroups.addAll(fieldGroups);
        AlignIndexFinder<FieldDeclaration> nameFinder = fd -> this.findName((VariableDeclarationFragment)fd.fragments().get(0));
        fieldGroups.forEach(fg -> this.alignNodes((List)fg, nameFinder));
        AlignIndexFinder<FieldDeclaration> assignFinder = fd -> this.findAssign((VariableDeclarationFragment)fd.fragments().get(0));
        fieldGroups.forEach(fg -> this.alignNodes((List)fg, assignFinder));
    }

    public void handleAlign(Block block) {
        List statements = block.statements();
        if (this.areKeptOnOneLine(statements)) {
            return;
        }
        if (this.options.align_variable_declarations_on_columns) {
            this.alignDeclarations(statements);
        }
        if (this.options.align_assignment_statements_on_columns) {
            this.alignAssignmentStatements(statements);
        }
    }

    private boolean areKeptOnOneLine(List<? extends ASTNode> nodes) {
        return nodes.stream().allMatch(n -> this.tm.firstTokenIn((ASTNode)n, -1).getLineBreaksBefore() == 0);
    }

    private void alignDeclarations(List<Statement> statements) {
        List variableGroups = this.toAlignGroups(statements, n -> this.optionalCast((ASTNode)n, (Class)VariableDeclarationStatement.class));
        this.alignGroups.addAll(variableGroups);
        AlignIndexFinder<VariableDeclarationStatement> nameFinder = vd -> this.findName((VariableDeclarationFragment)vd.fragments().get(0));
        variableGroups.forEach(vg -> this.alignNodes((List)vg, nameFinder));
        AlignIndexFinder<VariableDeclarationStatement> assignFinder = vd -> this.findAssign((VariableDeclarationFragment)vd.fragments().get(0));
        variableGroups.forEach(vg -> this.alignNodes((List)vg, assignFinder));
    }

    private void alignAssignmentStatements(List<Statement> statements) {
        List assignmentGroups = this.toAlignGroups(statements, n -> this.optionalCast((ASTNode)n, (Class)ExpressionStatement.class).filter(es -> es.getExpression() instanceof Assignment));
        this.alignGroups.addAll(assignmentGroups);
        AlignIndexFinder<ExpressionStatement> assignFinder = es -> {
            Assignment a = (Assignment)es.getExpression();
            int operatorIndex = this.tm.firstIndexBefore(a.getRightHandSide(), -1);
            while (this.tm.get(operatorIndex).isComment()) {
                --operatorIndex;
            }
            return Optional.of(operatorIndex);
        };
        assignmentGroups.forEach(ag -> this.alignNodes((List)ag, assignFinder));
        if (this.options.align_with_spaces || this.options.tab_char != 1) {
            for (List group : assignmentGroups) {
                List assignTokens = group.stream().map(assignFinder::findIndex).filter(Optional::isPresent).map(o -> this.tm.get((Integer)o.get())).collect(Collectors.toList());
                int maxWidth = assignTokens.stream().mapToInt(Token::countChars).max().orElse(0);
                for (Token token : assignTokens) {
                    token.setAlign(token.getAlign() + maxWidth - token.countChars());
                }
            }
        }
    }

    private <N extends ASTNode> Optional<N> optionalCast(ASTNode node, Class<N> c) {
        return Optional.of(node).filter(c::isInstance).map(c::cast);
    }

    private Optional<Integer> findName(VariableDeclarationFragment fragment) {
        int nameIndex = this.tm.firstIndexIn(fragment.getName(), 22);
        return Optional.of(nameIndex);
    }

    private Optional<Integer> findAssign(VariableDeclarationFragment fragment) {
        return Optional.ofNullable(fragment.getInitializer()).map(i -> this.tm.firstIndexBefore((ASTNode)i, 73));
    }

    private <N extends ASTNode> List<List<N>> toAlignGroups(List<? extends ASTNode> nodes, Function<ASTNode, Optional<N>> nodeConverter) {
        ArrayList<List<N>> result = new ArrayList<List<N>>();
        ArrayList<ASTNode> alignGroup = new ArrayList<ASTNode>();
        ASTNode previous = null;
        for (ASTNode aSTNode : nodes) {
            Optional<N> converted = nodeConverter.apply(aSTNode);
            if (converted.isPresent()) {
                if (this.isNewGroup(aSTNode, previous)) {
                    result.add(alignGroup);
                    alignGroup = new ArrayList();
                }
                alignGroup.add((ASTNode)converted.get());
            }
            previous = converted.orElse(null);
        }
        result.add(alignGroup);
        result.removeIf(l -> l.size() < 2);
        return result;
    }

    private boolean isNewGroup(ASTNode node, ASTNode previousNode) {
        if (previousNode == null) {
            return true;
        }
        int totalLineBreaks = 0;
        int from = this.tm.lastIndexIn(previousNode, -1);
        int to = this.tm.firstIndexIn(node, -1);
        Token previousToken = this.tm.get(from);
        int i = from + 1;
        while (i <= to) {
            Token token = this.tm.get(i);
            int lineBreaks = Math.max(previousToken.getLineBreaksAfter(), token.getLineBreaksBefore());
            if (previousToken.isPreserveLineBreaksAfter() && token.isPreserveLineBreaksBefore()) {
                lineBreaks = Math.max(lineBreaks, Math.min(this.tm.countLineBreaksBetween(previousToken, token), this.options.number_of_empty_lines_to_preserve + 1));
            }
            totalLineBreaks += lineBreaks;
            previousToken = token;
            ++i;
        }
        return totalLineBreaks > this.options.align_fields_grouping_blank_lines;
    }

    private <N extends ASTNode> void alignNodes(List<N> alignGroup, AlignIndexFinder<N> tokenFinder) {
        int[] tokenIndexes = alignGroup.stream().map(tokenFinder::findIndex).filter(Optional::isPresent).mapToInt(Optional::get).toArray();
        OptionalInt maxPosition = IntStream.of(tokenIndexes).map(this.tm::getPositionInLine).max();
        if (maxPosition.isPresent()) {
            int align = this.normalizedAlign(maxPosition.getAsInt());
            int[] nArray = tokenIndexes;
            int n = tokenIndexes.length;
            int n2 = 0;
            while (n2 < n) {
                int tokenIndex = nArray[n2];
                this.tm.get(tokenIndex).setAlign(align);
                ++n2;
            }
        }
    }

    public void alignComments() {
        boolean alignLineComments = !this.options.comment_preserve_white_space_between_code_and_line_comments;
        PositionCounter positionCounter = new PositionCounter();
        for (List<? extends ASTNode> alignGroup : this.alignGroups) {
            int lastIndex;
            int firstIndexInLine;
            int maxCommentAlign = 0;
            for (ASTNode aSTNode : alignGroup) {
                firstIndexInLine = this.findFirstTokenInLine(aSTNode);
                lastIndex = this.tm.lastIndexIn(aSTNode, -1) + 1;
                maxCommentAlign = Math.max(maxCommentAlign, positionCounter.findMaxPosition(firstIndexInLine, lastIndex));
            }
            maxCommentAlign = this.normalizedAlign(maxCommentAlign);
            for (ASTNode aSTNode : alignGroup) {
                firstIndexInLine = this.findFirstTokenInLine(aSTNode);
                lastIndex = this.tm.lastIndexIn(aSTNode, -1);
                lastIndex = Math.min(lastIndex, this.tm.size() - 2);
                int i = firstIndexInLine;
                while (i <= lastIndex) {
                    boolean lineBreak;
                    Token token = this.tm.get(i);
                    Token next = this.tm.get(i + 1);
                    boolean bl = lineBreak = token.getLineBreaksAfter() > 0 || next.getLineBreaksBefore() > 0;
                    if (lineBreak) {
                        if (token.tokenType == 1002) {
                            token.setAlign(maxCommentAlign);
                        } else if (alignLineComments) {
                            this.tm.addNLSAlignIndex(i, maxCommentAlign);
                        }
                    } else if (next.tokenType == 1001 && alignLineComments || next.tokenType == 1002 && i == lastIndex) {
                        next.setAlign(maxCommentAlign);
                    }
                    ++i;
                }
            }
        }
    }

    private int findFirstTokenInLine(ASTNode node) {
        if (node instanceof FieldDeclaration) {
            int typeIndex = this.tm.firstIndexIn(((FieldDeclaration)node).getType(), -1);
            return this.tm.findFirstTokenInLine(typeIndex);
        }
        if (node instanceof VariableDeclarationStatement) {
            int typeIndex = this.tm.firstIndexIn(((VariableDeclarationStatement)node).getType(), -1);
            return this.tm.findFirstTokenInLine(typeIndex);
        }
        if (node instanceof ExpressionStatement) {
            return this.tm.firstIndexIn(node, -1);
        }
        throw new IllegalArgumentException(node.getClass().getName());
    }

    private int normalizedAlign(int desiredAlign) {
        if (this.options.align_with_spaces) {
            return desiredAlign;
        }
        return this.tm.toIndent(desiredAlign, false);
    }

    @FunctionalInterface
    private static interface AlignIndexFinder<N extends ASTNode> {
        public Optional<Integer> findIndex(N var1);
    }

    private class PositionCounter
    extends TokenTraverser {
        int stoppingIndex;
        int maxPosition;

        @Override
        protected boolean token(Token token, int index) {
            if (index == this.stoppingIndex) {
                return false;
            }
            if (this.getLineBreaksBefore() > 0) {
                this.counter = Aligner.this.tm.getPositionInLine(index);
            }
            if (token.getAlign() > 0) {
                this.counter = token.getAlign();
            }
            this.counter += Aligner.this.tm.getLength(token, this.counter);
            if (this.isSpaceAfter() && this.getLineBreaksAfter() == 0) {
                ++this.counter;
            }
            this.maxPosition = Math.max(this.maxPosition, this.counter);
            return true;
        }

        public int findMaxPosition(int fromIndex, int toIndex) {
            this.counter = Aligner.this.tm.getPositionInLine(fromIndex);
            this.stoppingIndex = toIndex;
            this.maxPosition = 0;
            Aligner.this.tm.traverse(fromIndex, this);
            return this.maxPosition;
        }
    }
}

