/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.container;

import java.security.Permission;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.BundlePermission;
import org.greenrobot.osgi.framework.CapabilityPermission;
import org.greenrobot.osgi.framework.PackagePermission;
import org.greenrobot.osgi.framework.wiring.BundleCapability;
import org.greenrobot.osgi.framework.wiring.BundleRequirement;
import org.greenrobot.osgi.framework.wiring.BundleRevision;
import org.greenrobot.osgi.framework.wiring.BundleWire;
import org.greenrobot.osgi.framework.wiring.BundleWiring;
import org.greenrobot.osgi.resource.Capability;
import org.greenrobot.osgi.resource.Requirement;
import org.greenrobot.osgi.resource.Resource;
import org.greenrobot.osgi.resource.Wire;

public class InternalUtils {
    public static List<Capability> asListCapability(List<? extends Capability> l) {
        return l;
    }

    public static List<Requirement> asListRequirement(List<? extends Requirement> l) {
        return l;
    }

    public static List<BundleCapability> asListBundleCapability(List<? extends BundleCapability> l) {
        return l;
    }

    public static List<BundleRequirement> asListBundleRequirement(List<? extends BundleRequirement> l) {
        return l;
    }

    public static List<BundleWire> asListBundleWire(List<? extends BundleWire> l) {
        return l;
    }

    public static List<Wire> asListWire(List<? extends Wire> l) {
        return l;
    }

    public static List<BundleRevision> asListBundleRevision(List<? extends BundleRevision> l) {
        return l;
    }

    public static Collection<Resource> asCollectionResource(Collection<? extends Resource> c) {
        return c;
    }

    public static Collection<BundleWiring> asCollectionBundleWiring(Collection<? extends BundleWiring> c) {
        return c;
    }

    public static void filterCapabilityPermissions(Collection<? extends BundleCapability> capabilities) {
        if (System.getSecurityManager() == null) {
            return;
        }
        Iterator<? extends BundleCapability> iCapabilities = capabilities.iterator();
        while (iCapabilities.hasNext()) {
            BundleCapability capability = iCapabilities.next();
            Permission permission = InternalUtils.getProvidePermission(capability);
            Bundle provider = capability.getRevision().getBundle();
            if (provider == null || provider.hasPermission(permission)) continue;
            iCapabilities.remove();
        }
    }

    public static Permission getRequirePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), candidate.getRevision().getBundle(), "import");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "fragment");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "require");
        }
        return new CapabilityPermission(name, candidate.getAttributes(), candidate.getRevision().getBundle(), "require");
    }

    public static Permission getProvidePermission(BundleCapability candidate) {
        String name = candidate.getNamespace();
        if ("osgi.wiring.package".equals(name)) {
            return new PackagePermission(InternalUtils.getPermisionName(candidate), "exportonly");
        }
        if ("osgi.wiring.host".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "host");
        }
        if ("osgi.wiring.bundle".equals(name)) {
            return new BundlePermission(InternalUtils.getPermisionName(candidate), "provide");
        }
        return new CapabilityPermission(name, "provide");
    }

    private static String getPermisionName(BundleCapability candidate) {
        Object name = candidate.getAttributes().get(candidate.getNamespace());
        if (name instanceof String) {
            return (String)name;
        }
        if (name instanceof Collection) {
            Collection names = (Collection)name;
            return names.isEmpty() ? "unknown" : names.iterator().next().toString();
        }
        return "unknown";
    }
}

