/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.log;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import org.greenrobot.eclipse.equinox.log.Logger;
import org.greenrobot.eclipse.osgi.framework.log.FrameworkLog;
import org.greenrobot.eclipse.osgi.framework.log.FrameworkLogEntry;
import org.greenrobot.eclipse.osgi.internal.log.EquinoxLogWriter;
import org.greenrobot.eclipse.osgi.internal.log.LogServiceManager;
import org.greenrobot.osgi.framework.Bundle;
import org.greenrobot.osgi.framework.FrameworkEvent;
import org.greenrobot.osgi.framework.ServiceFactory;
import org.greenrobot.osgi.framework.ServiceRegistration;

class EquinoxLogFactory
implements ServiceFactory<FrameworkLog> {
    final EquinoxLogWriter defaultWriter;
    final LogServiceManager logManager;

    public EquinoxLogFactory(EquinoxLogWriter defaultWriter, LogServiceManager logManager) {
        this.defaultWriter = defaultWriter;
        this.logManager = logManager;
    }

    @Override
    public FrameworkLog getService(Bundle bundle, ServiceRegistration<FrameworkLog> registration) {
        return this.createFrameworkLog(bundle, this.defaultWriter);
    }

    FrameworkLog createFrameworkLog(Bundle bundle, EquinoxLogWriter eclipseWriter) {
        final EquinoxLogWriter logWriter = eclipseWriter == null ? this.defaultWriter : eclipseWriter;
        final Logger logger = bundle == null ? this.logManager.getSystemBundleLog().getLogger(eclipseWriter.getLoggerName()) : this.logManager.getSystemBundleLog().getLogger(bundle, logWriter.getLoggerName());
        return new FrameworkLog(){

            @Override
            public void setWriter(Writer newWriter, boolean append) {
                logWriter.setWriter(newWriter, append);
            }

            @Override
            public void setFile(File newFile, boolean append) throws IOException {
                logWriter.setFile(newFile, append);
            }

            @Override
            public void setConsoleLog(boolean consoleLog) {
                logWriter.setConsoleLog(consoleLog);
            }

            @Override
            public void log(FrameworkLogEntry logEntry) {
                logger.log(logEntry, EquinoxLogFactory.convertLevel(logEntry), logEntry.getMessage(), logEntry.getThrowable());
            }

            @Override
            public void log(FrameworkEvent frameworkEvent) {
                int severity;
                Bundle b = frameworkEvent.getBundle();
                Throwable t = frameworkEvent.getThrowable();
                String entry = b.getSymbolicName() == null ? b.getLocation() : b.getSymbolicName();
                switch (frameworkEvent.getType()) {
                    case 32: {
                        severity = 1;
                        break;
                    }
                    case 2: {
                        severity = 4;
                        break;
                    }
                    case 16: {
                        severity = 2;
                        break;
                    }
                    default: {
                        severity = 0;
                    }
                }
                FrameworkLogEntry logEntry = new FrameworkLogEntry(entry, severity, 0, "", 0, t, null);
                this.log(logEntry);
            }

            @Override
            public File getFile() {
                return logWriter.getFile();
            }

            @Override
            public void close() {
                logWriter.close();
            }
        };
    }

    @Override
    public void ungetService(Bundle bundle, ServiceRegistration<FrameworkLog> registration, FrameworkLog service) {
    }

    static int convertLevel(FrameworkLogEntry logEntry) {
        switch (logEntry.getSeverity()) {
            case 4: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
        }
        return 32;
    }
}

