/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.internal.url;

import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.greenrobot.eclipse.osgi.framework.util.SecureAction;
import org.greenrobot.eclipse.osgi.internal.framework.EquinoxContainer;
import org.greenrobot.eclipse.osgi.internal.messages.Msg;
import org.greenrobot.eclipse.osgi.internal.url.MultiplexingFactory;
import org.greenrobot.eclipse.osgi.internal.url.MultiplexingURLStreamHandler;
import org.greenrobot.eclipse.osgi.internal.url.URLStreamHandlerProxy;
import org.greenrobot.eclipse.osgi.storage.url.reference.Handler;
import org.greenrobot.eclipse.osgi.util.NLS;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.ServiceReference;
import org.greenrobot.osgi.service.url.URLStreamHandlerService;
import org.greenrobot.osgi.util.tracker.ServiceTracker;

public class URLStreamHandlerFactoryImpl
extends MultiplexingFactory
implements URLStreamHandlerFactory {
    protected static final String URLSTREAMHANDLERCLASS = "org.greenrobot.osgi.service.url.URLStreamHandlerService";
    protected static final String PROTOCOL_HANDLER_PKGS = "java.protocol.handler.pkgs";
    public static final String PROTOCOL_REFERENCE = "reference";
    static final SecureAction secureAction = AccessController.doPrivileged(SecureAction.createSecureAction());
    private ServiceTracker<URLStreamHandlerService, URLStreamHandlerService> handlerTracker;
    private static final List<Class<?>> ignoredClasses = Arrays.asList(MultiplexingURLStreamHandler.class, URLStreamHandlerFactoryImpl.class, URL.class);
    private Map<String, URLStreamHandler> proxies;
    private URLStreamHandlerFactory parentFactory;
    private ThreadLocal<List<String>> creatingProtocols = new ThreadLocal();

    public URLStreamHandlerFactoryImpl(BundleContext context, EquinoxContainer container) {
        super(context, container);
        this.proxies = new Hashtable<String, URLStreamHandler>(15);
        this.handlerTracker = new ServiceTracker(context, URLSTREAMHANDLERCLASS, null);
        this.handlerTracker.open();
    }

    private Class<?> getBuiltIn(String protocol, String builtInHandlers) {
        if (builtInHandlers == null) {
            return null;
        }
        StringTokenizer tok = new StringTokenizer(builtInHandlers, "|");
        while (tok.hasMoreElements()) {
            StringBuilder name = new StringBuilder();
            name.append(tok.nextToken());
            name.append(".");
            name.append(protocol);
            name.append(".Handler");
            try {
                Class<?> clazz = secureAction.loadSystemClass(name.toString());
                if (clazz == null) continue;
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return null;
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        if (this.isRecursive(protocol)) {
            return null;
        }
        try {
            String builtInHandlers = secureAction.getProperty(PROTOCOL_HANDLER_PKGS);
            Class<?> clazz = this.getBuiltIn(protocol, builtInHandlers);
            if (clazz != null) {
                return null;
            }
            URLStreamHandler result = null;
            if (this.isMultiplexing()) {
                URLStreamHandler authorized = this.findAuthorizedURLStreamHandler(protocol);
                if (authorized != null) {
                    result = new MultiplexingURLStreamHandler(protocol, this, authorized);
                }
            } else {
                result = this.createInternalURLStreamHandler(protocol);
            }
            if (result == null && this.parentFactory != null) {
                result = this.parentFactory.createURLStreamHandler(protocol);
            }
            URLStreamHandler uRLStreamHandler = result;
            return uRLStreamHandler;
        }
        catch (Throwable t) {
            this.container.getLogServices().log(URLStreamHandlerFactoryImpl.class.getName(), 4, "Unexpected error in factory.", t);
            return null;
        }
        finally {
            this.releaseRecursive(protocol);
        }
    }

    private boolean isRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        if (protocols == null) {
            protocols = new ArrayList<String>(1);
            this.creatingProtocols.set(protocols);
        }
        if (protocols.contains(protocol)) {
            return true;
        }
        protocols.add(protocol);
        return false;
    }

    private void releaseRecursive(String protocol) {
        List<String> protocols = this.creatingProtocols.get();
        protocols.remove(protocol);
    }

    private URLStreamHandler getFrameworkHandler(String protocol) {
        if ("bundleentry".equals(protocol)) {
            return new org.greenrobot.eclipse.osgi.storage.url.bundleentry.Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if ("bundleresource".equals(protocol)) {
            return new org.greenrobot.eclipse.osgi.storage.url.bundleresource.Handler(this.container.getStorage().getModuleContainer(), null);
        }
        if (PROTOCOL_REFERENCE.equals(protocol)) {
            return new Handler(this.container.getConfiguration().getConfiguration("osgi.install.area"));
        }
        return null;
    }

    public URLStreamHandler createInternalURLStreamHandler(String protocol) {
        URLStreamHandler frameworkHandler = this.getFrameworkHandler(protocol);
        if (frameworkHandler != null) {
            return frameworkHandler;
        }
        URLStreamHandlerProxy handler = (URLStreamHandlerProxy)this.proxies.get(protocol);
        if (handler != null) {
            return handler;
        }
        ServiceReference<URLStreamHandlerService>[] serviceReferences = this.handlerTracker.getServiceReferences();
        if (serviceReferences == null) {
            return null;
        }
        ServiceReference<URLStreamHandlerService>[] serviceReferenceArray = serviceReferences;
        int n = serviceReferences.length;
        int n2 = 0;
        while (n2 < n) {
            ServiceReference<URLStreamHandlerService> serviceReference = serviceReferenceArray[n2];
            String[] prop = serviceReference.getProperty("url.handler.protocol");
            if (prop instanceof String) {
                prop = new String[]{(String)prop};
            }
            if (!(prop instanceof String[])) {
                String message = NLS.bind(Msg.URL_HANDLER_INCORRECT_TYPE, new Object[]{"url.handler.protocol", URLSTREAMHANDLERCLASS, serviceReference.getBundle()});
                this.container.getLogServices().log("org.greenrobot.eclipse.osgi", 2, message, null);
            } else {
                String[] protocols;
                String[] stringArray = protocols = (String[])prop;
                int n3 = protocols.length;
                int n4 = 0;
                while (n4 < n3) {
                    String candidateProtocol = stringArray[n4];
                    if (candidateProtocol.equals(protocol)) {
                        handler = new URLStreamHandlerProxy(protocol, serviceReference, this.context);
                        this.proxies.put(protocol, handler);
                        return handler;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return null;
    }

    protected URLStreamHandler findAuthorizedURLStreamHandler(String protocol) {
        Object factory = this.findAuthorizedFactory(ignoredClasses);
        if (factory == null) {
            return null;
        }
        if (factory == this) {
            return this.createInternalURLStreamHandler(protocol);
        }
        try {
            Method createInternalURLStreamHandlerMethod = factory.getClass().getMethod("createInternalURLStreamHandler", String.class);
            return (URLStreamHandler)createInternalURLStreamHandlerMethod.invoke(factory, protocol);
        }
        catch (Exception e) {
            this.container.getLogServices().log(URLStreamHandlerFactoryImpl.class.getName(), 4, "findAuthorizedURLStreamHandler-loop", e);
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public Object getParentFactory() {
        return this.parentFactory;
    }

    @Override
    public void setParentFactory(Object parentFactory) {
        if (this.parentFactory == null) {
            this.parentFactory = (URLStreamHandlerFactory)parentFactory;
        }
    }
}

