/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.eclipse.osgi.storage;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.TimeUnit;
import org.greenrobot.eclipse.osgi.internal.debug.Debug;
import org.greenrobot.osgi.framework.BundleContext;
import org.greenrobot.osgi.framework.ServiceRegistration;

public class StorageUtil {
    public static final byte NULL = 0;
    public static final byte OBJECT = 1;

    public static void copyDir(File inDir, File outDir) throws IOException {
        String[] files = inDir.list();
        if (files != null && files.length > 0) {
            outDir.mkdir();
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File inFile = new File(inDir, file);
                File outFile = new File(outDir, file);
                if (inFile.isDirectory()) {
                    StorageUtil.copyDir(inFile, outFile);
                } else {
                    FileInputStream in = new FileInputStream(inFile);
                    StorageUtil.readFile(in, outFile);
                }
                ++n2;
            }
        }
    }

    public static void readFile(InputStream in, File file) throws IOException {
        FileOutputStream fos = null;
        try {
            int count;
            fos = new FileOutputStream(file);
            byte[] buffer = new byte[1024];
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                fos.write(buffer, 0, count);
            }
        }
        catch (Throwable throwable) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
        if (fos != null) {
            try {
                fos.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static boolean rm(File file, boolean DEBUG) {
        if (file.exists()) {
            String[] list;
            if (file.isDirectory() && (list = file.list()) != null) {
                int len = list.length;
                int i = 0;
                while (i < len) {
                    StorageUtil.rm(new File(file, list[i]), DEBUG);
                    ++i;
                }
            }
            if (DEBUG) {
                if (file.isDirectory()) {
                    Debug.println("rmdir " + file.getPath());
                } else {
                    Debug.println("rm " + file.getPath());
                }
            }
            boolean success = file.delete();
            if (DEBUG && !success) {
                Debug.println("  rm failed!");
            }
            return success;
        }
        return true;
    }

    public static String readString(DataInputStream in, boolean intern) throws IOException {
        byte type = in.readByte();
        if (type == 0) {
            return null;
        }
        return intern ? in.readUTF().intern() : in.readUTF();
    }

    public static void writeStringOrNull(DataOutputStream out, String string) throws IOException {
        if (string == null) {
            out.writeByte(0);
        } else {
            out.writeByte(1);
            out.writeUTF(string);
        }
    }

    public static ServiceRegistration<?> register(String name, Object service, BundleContext context) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        ((Dictionary)properties).put("service.ranking", Integer.MAX_VALUE);
        ((Dictionary)properties).put("service.pid", String.valueOf(context.getBundle().getBundleId()) + "." + service.getClass().getName());
        return context.registerService(name, service, properties);
    }

    public static boolean canWrite(File installDir) {
        return installDir.isDirectory() && Files.isWritable(installDir.toPath());
    }

    public static URL encodeFileURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static byte[] getBytes(InputStream in, int length, int BUF_SIZE) throws IOException {
        byte[] classbytes;
        int bytesread = 0;
        try {
            byte[] oldbytes;
            if (length > 0) {
                classbytes = new byte[length];
                while (bytesread < length) {
                    int readcount = in.read(classbytes, bytesread, length - bytesread);
                    if (readcount > 0) {
                        bytesread += readcount;
                        continue;
                    }
                    break;
                }
            } else {
                length = BUF_SIZE;
                classbytes = new byte[length];
                while (true) {
                    if (bytesread < length) {
                        int readcount = in.read(classbytes, bytesread, length - bytesread);
                        if (readcount > 0) {
                            bytesread += readcount;
                            continue;
                        }
                        break;
                    }
                    oldbytes = classbytes;
                    classbytes = new byte[length += BUF_SIZE];
                    System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
                }
            }
            if (classbytes.length > bytesread) {
                oldbytes = classbytes;
                classbytes = new byte[bytesread];
                System.arraycopy(oldbytes, 0, classbytes, 0, bytesread);
            }
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return classbytes;
    }

    public static boolean move(File from, File to, boolean DEBUG) {
        int tryCount = 0;
        int sleep = 200;
        while (true) {
            if (from.renameTo(to)) {
                return true;
            }
            if (DEBUG) {
                Debug.println("move: failed to rename " + from + " to " + to + " (" + (10 - tryCount) + " attempts remaining)");
            }
            if (tryCount >= 10) break;
            try {
                TimeUnit.MILLISECONDS.sleep(sleep);
            }
            catch (InterruptedException interruptedException) {}
            sleep += 200;
            ++tryCount;
        }
        try {
            if (from.isDirectory()) {
                StorageUtil.copyDir(from, to);
            } else {
                StorageUtil.readFile(new FileInputStream(from), to);
            }
            if (!StorageUtil.rm(from, DEBUG)) {
                Debug.println("move: failed to delete " + from + " after copy to " + to + ". Scheduling for delete on JVM exit.");
                from.deleteOnExit();
            }
            return true;
        }
        catch (IOException e) {
            if (DEBUG) {
                Debug.println("move: failed to copy " + from + " to " + to);
                Debug.printStackTrace(e);
            }
            return false;
        }
    }
}

