/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.search.Similarity;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.annotations.common.util.StringHelper;
import org.hibernate.search.SearchException;
import org.hibernate.search.Version;
import org.hibernate.search.backend.BackendQueueProcessorFactory;
import org.hibernate.search.backend.LuceneIndexingParameters;
import org.hibernate.search.backend.LuceneWork;
import org.hibernate.search.backend.OptimizeLuceneWork;
import org.hibernate.search.backend.Worker;
import org.hibernate.search.backend.configuration.MaskedProperty;
import org.hibernate.search.backend.impl.batchlucene.BatchBackend;
import org.hibernate.search.backend.impl.batchlucene.LuceneBatchBackend;
import org.hibernate.search.batchindexing.MassIndexerProgressMonitor;
import org.hibernate.search.engine.DocumentBuilderContainedEntity;
import org.hibernate.search.engine.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.FilterDef;
import org.hibernate.search.engine.SearchFactoryImplementor;
import org.hibernate.search.engine.ServiceManager;
import org.hibernate.search.exception.ErrorHandler;
import org.hibernate.search.filter.FilterCachingStrategy;
import org.hibernate.search.jmx.JMXRegistrar;
import org.hibernate.search.jmx.StatisticsInfo;
import org.hibernate.search.query.dsl.QueryContextBuilder;
import org.hibernate.search.query.dsl.impl.ConnectedQueryContextBuilder;
import org.hibernate.search.reader.ReaderProvider;
import org.hibernate.search.spi.ServiceProvider;
import org.hibernate.search.spi.WorkerBuildContext;
import org.hibernate.search.spi.internals.DirectoryProviderData;
import org.hibernate.search.spi.internals.PolymorphicIndexHierarchy;
import org.hibernate.search.spi.internals.SearchFactoryImplementorWithShareableState;
import org.hibernate.search.spi.internals.SearchFactoryState;
import org.hibernate.search.stat.Statistics;
import org.hibernate.search.stat.StatisticsImpl;
import org.hibernate.search.stat.StatisticsImplementor;
import org.hibernate.search.store.DirectoryProvider;
import org.hibernate.search.store.optimization.OptimizerStrategy;
import org.hibernate.search.util.ClassLoaderHelper;
import org.hibernate.search.util.LoggerFactory;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImmutableSearchFactory
implements SearchFactoryImplementorWithShareableState,
WorkerBuildContext {
    private static final Logger log;
    private final Map<Class<?>, DocumentBuilderIndexedEntity<?>> documentBuildersIndexedEntities;
    private final Map<Class<?>, DocumentBuilderContainedEntity<?>> documentBuildersContainedEntities;
    private final Map<DirectoryProvider<?>, DirectoryProviderData> dirProviderData;
    private final Worker worker;
    private final ReaderProvider readerProvider;
    private final BackendQueueProcessorFactory backendQueueProcessorFactory;
    private final Map<String, FilterDef> filterDefinitions;
    private final FilterCachingStrategy filterCachingStrategy;
    private final Map<String, Analyzer> analyzers;
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final int cacheBitResultsSize;
    private final Properties configurationProperties;
    private final ErrorHandler errorHandler;
    private final PolymorphicIndexHierarchy indexHierarchy;
    private final StatisticsImpl statistics;
    private final Map<DirectoryProvider, LuceneIndexingParameters> dirProviderIndexingParams;
    private final String indexingStrategy;
    private final ServiceManager serviceManager;

    public ImmutableSearchFactory(SearchFactoryState state) {
        this.analyzers = state.getAnalyzers();
        this.backendQueueProcessorFactory = state.getBackendQueueProcessorFactory();
        this.cacheBitResultsSize = state.getCacheBitResultsSize();
        this.configurationProperties = state.getConfigurationProperties();
        this.dirProviderData = state.getDirectoryProviderData();
        this.dirProviderIndexingParams = state.getDirectoryProviderIndexingParams();
        this.documentBuildersIndexedEntities = state.getDocumentBuildersIndexedEntities();
        this.documentBuildersContainedEntities = state.getDocumentBuildersContainedEntities();
        this.errorHandler = state.getErrorHandler();
        this.filterCachingStrategy = state.getFilterCachingStrategy();
        this.filterDefinitions = state.getFilterDefinitions();
        this.indexHierarchy = state.getIndexHierarchy();
        this.indexingStrategy = state.getIndexingStrategy();
        this.readerProvider = state.getReaderProvider();
        this.worker = state.getWorker();
        this.serviceManager = state.getServiceManager();
        this.statistics = new StatisticsImpl(this);
        String enableStats = this.configurationProperties.getProperty("hibernate.search.generate_statistics");
        if ("true".equalsIgnoreCase(enableStats)) {
            this.statistics.setStatisticsEnabled(true);
        }
        if (this.isJMXEnabled()) {
            if (JMXRegistrar.isNameRegistered("org.hibernate.search.jmx:type=StatisticsInfoMBean")) {
                JMXRegistrar.unRegisterMBean("org.hibernate.search.jmx:type=StatisticsInfoMBean");
            }
            JMXRegistrar.registerMBean(new StatisticsInfo(this.statistics), "org.hibernate.search.jmx:type=StatisticsInfoMBean");
        }
    }

    @Override
    public BackendQueueProcessorFactory getBackendQueueProcessorFactory() {
        return this.backendQueueProcessorFactory;
    }

    @Override
    public Map<String, FilterDef> getFilterDefinitions() {
        return this.filterDefinitions;
    }

    @Override
    public String getIndexingStrategy() {
        return this.indexingStrategy;
    }

    @Override
    public void close() {
        if (this.stopped.compareAndSet(false, true)) {
            try {
                this.worker.close();
            }
            catch (Exception e) {
                log.error("Worker raises an exception on close()", (Throwable)e);
            }
            try {
                this.readerProvider.destroy();
            }
            catch (Exception e) {
                log.error("ReaderProvider raises an exception on destroy()", (Throwable)e);
            }
            for (DirectoryProvider<?> dp : this.getDirectoryProviders()) {
                try {
                    dp.stop();
                }
                catch (Exception e) {
                    log.error("DirectoryProvider raises an exception on stop() ", (Throwable)e);
                }
            }
            this.serviceManager.stopServices();
        }
    }

    @Override
    public Set<Class<?>> getClassesInDirectoryProvider(DirectoryProvider<?> directoryProvider) {
        return Collections.unmodifiableSet(this.dirProviderData.get(directoryProvider).getClasses());
    }

    @Override
    public Map<Class<?>, DocumentBuilderContainedEntity<?>> getDocumentBuildersContainedEntities() {
        return this.documentBuildersContainedEntities;
    }

    @Override
    public Map<DirectoryProvider<?>, DirectoryProviderData> getDirectoryProviderData() {
        return this.dirProviderData;
    }

    @Override
    public Map<Class<?>, DocumentBuilderIndexedEntity<?>> getDocumentBuildersIndexedEntities() {
        return this.documentBuildersIndexedEntities;
    }

    @Override
    public <T> DocumentBuilderIndexedEntity<T> getDocumentBuilderIndexedEntity(Class<T> entityType) {
        return this.documentBuildersIndexedEntities.get(entityType);
    }

    @Override
    public <T> DocumentBuilderContainedEntity<T> getDocumentBuilderContainedEntity(Class<T> entityType) {
        return this.documentBuildersContainedEntities.get(entityType);
    }

    @Override
    public Set<DirectoryProvider<?>> getDirectoryProviders() {
        return this.dirProviderData.keySet();
    }

    @Override
    public void addClasses(Class<?> ... classes) {
        throw new AssertionFailure("Cannot add classes to an " + ImmutableSearchFactory.class.getName());
    }

    @Override
    public Worker getWorker() {
        return this.worker;
    }

    @Override
    public void setBackendQueueProcessorFactory(BackendQueueProcessorFactory backendQueueProcessorFactory) {
        throw new AssertionFailure("ImmutableSearchFactory is immutable: should never be called");
    }

    @Override
    public OptimizerStrategy getOptimizerStrategy(DirectoryProvider<?> provider) {
        return this.dirProviderData.get(provider).getOptimizerStrategy();
    }

    @Override
    public LuceneIndexingParameters getIndexingParameters(DirectoryProvider<?> provider) {
        return this.dirProviderIndexingParams.get(provider);
    }

    @Override
    public ReaderProvider getReaderProvider() {
        return this.readerProvider;
    }

    @Override
    public DirectoryProvider[] getDirectoryProviders(Class<?> entity) {
        DocumentBuilderIndexedEntity<?> documentBuilder = this.getDocumentBuilderIndexedEntity(entity);
        return documentBuilder == null ? null : documentBuilder.getDirectoryProviders();
    }

    @Override
    public void optimize() {
        Set<Class<?>> clazzs = this.getDocumentBuildersIndexedEntities().keySet();
        for (Class<?> clazz : clazzs) {
            this.optimize(clazz);
        }
    }

    @Override
    public void optimize(Class entityType) {
        if (!this.getDocumentBuildersIndexedEntities().containsKey(entityType)) {
            throw new SearchException("Entity not indexed: " + entityType);
        }
        ArrayList<LuceneWork> queue = new ArrayList<LuceneWork>(1);
        queue.add(new OptimizeLuceneWork(entityType));
        this.getBackendQueueProcessorFactory().getProcessor(queue).run();
    }

    @Override
    public Analyzer getAnalyzer(String name) {
        Analyzer analyzer = this.analyzers.get(name);
        if (analyzer == null) {
            throw new SearchException("Unknown Analyzer definition: " + name);
        }
        return analyzer;
    }

    @Override
    public Analyzer getAnalyzer(Class<?> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("A class has to be specified for retrieving a scoped analyzer");
        }
        DocumentBuilderIndexedEntity<?> builder = this.documentBuildersIndexedEntities.get(clazz);
        if (builder == null) {
            throw new IllegalArgumentException("Entity for which to retrieve the scoped analyzer is not an @Indexed entity: " + clazz.getName());
        }
        return builder.getAnalyzer();
    }

    @Override
    public QueryContextBuilder buildQueryBuilder() {
        return new ConnectedQueryContextBuilder(this);
    }

    @Override
    public Statistics getStatistics() {
        return this.statistics;
    }

    @Override
    public StatisticsImplementor getStatisticsImplementor() {
        return this.statistics;
    }

    @Override
    public FilterCachingStrategy getFilterCachingStrategy() {
        return this.filterCachingStrategy;
    }

    @Override
    public Map<String, Analyzer> getAnalyzers() {
        return this.analyzers;
    }

    @Override
    public int getCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    @Override
    public FilterDef getFilterDefinition(String name) {
        return this.filterDefinitions.get(name);
    }

    @Override
    public ReentrantLock getDirectoryProviderLock(DirectoryProvider<?> dp) {
        return this.dirProviderData.get(dp).getDirLock();
    }

    @Override
    public <T> T requestService(Class<? extends ServiceProvider<T>> provider) {
        return this.serviceManager.requestService(provider);
    }

    @Override
    public void releaseService(Class<? extends ServiceProvider<?>> provider) {
        this.serviceManager.releaseService(provider);
    }

    @Override
    public int getFilterCacheBitResultsSize() {
        return this.cacheBitResultsSize;
    }

    @Override
    public Set<Class<?>> getIndexedTypesPolymorphic(Class<?>[] classes) {
        return this.indexHierarchy.getIndexedClasses(classes);
    }

    @Override
    public BatchBackend makeBatchBackend(MassIndexerProgressMonitor progressMonitor) {
        String impl = this.configurationProperties.getProperty("hibernate.search.batchbackend");
        BatchBackend batchBackend = StringHelper.isEmpty((String)impl) || "LuceneBatch".equalsIgnoreCase(impl) ? new LuceneBatchBackend() : ClassLoaderHelper.instanceFromName(BatchBackend.class, impl, ImmutableSearchFactory.class, "batchbackend");
        MaskedProperty batchBackendConfiguration = new MaskedProperty(this.configurationProperties, "hibernate.search.batchbackend");
        batchBackend.initialize(batchBackendConfiguration, progressMonitor, this);
        return batchBackend;
    }

    @Override
    public Similarity getSimilarity(DirectoryProvider<?> provider) {
        Similarity similarity = this.dirProviderData.get(provider).getSimilarity();
        if (similarity == null) {
            throw new SearchException("Assertion error: a similarity should be defined for each provider");
        }
        return similarity;
    }

    @Override
    public boolean isExclusiveIndexUsageEnabled(DirectoryProvider<?> provider) {
        return this.dirProviderData.get(provider).isExclusiveIndexUsage();
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public PolymorphicIndexHierarchy getIndexHierarchy() {
        return this.indexHierarchy;
    }

    @Override
    public Map<DirectoryProvider, LuceneIndexingParameters> getDirectoryProviderIndexingParams() {
        return this.dirProviderIndexingParams;
    }

    @Override
    public ServiceManager getServiceManager() {
        return this.serviceManager;
    }

    @Override
    public SearchFactoryImplementor getUninitializedSearchFactory() {
        return this;
    }

    @Override
    public boolean isJMXEnabled() {
        String enableJMX = this.getConfigurationProperties().getProperty("hibernate.search.jmx_enabled");
        return "true".equalsIgnoreCase(enableJMX);
    }

    static {
        Version.touch();
        log = LoggerFactory.make();
    }
}

