/**********************************************************\
|                                                          |
|                          hprose                          |
|                                                          |
| Official WebSite: http://www.hprose.com/                 |
|                   http://www.hprose.org/                 |
|                                                          |
\**********************************************************/
/**********************************************************\
 *                                                        *
 * BigDecimalArraySerializer.java                         *
 *                                                        *
 * BigDecimal array serializer class for Java.            *
 *                                                        *
 * LastModified: Apr 17, 2016                             *
 * Author: Ma Bingyao <andot@hprose.com>                  *
 *                                                        *
\**********************************************************/

package hprose.io.serialize;

import static hprose.io.HproseTags.TagClosebrace;
import static hprose.io.HproseTags.TagList;
import static hprose.io.HproseTags.TagNull;
import static hprose.io.HproseTags.TagOpenbrace;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;

final class BigDecimalArraySerializer implements Serializer<BigDecimal[]> {

    public final static BigDecimalArraySerializer instance = new BigDecimalArraySerializer();

    public final static void write(OutputStream stream, WriterRefer refer, BigDecimal[] array) throws IOException {
        if (refer != null) refer.set(array);
        int length = array.length;
        stream.write(TagList);
        if (length > 0) {
            ValueWriter.writeInt(stream, length);
        }
        stream.write(TagOpenbrace);
        for (int i = 0; i < length; ++i) {
            BigDecimal e = array[i];
            if (e == null) {
                stream.write(TagNull);
            }
            else {
                ValueWriter.write(stream, e);
            }
        }
        stream.write(TagClosebrace);
    }

    public final void write(Writer writer, BigDecimal[] obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            write(stream, refer, obj);
        }
    }
}
