/**********************************************************\
|                                                          |
|                          hprose                          |
|                                                          |
| Official WebSite: http://www.hprose.com/                 |
|                   http://www.hprose.org/                 |
|                                                          |
\**********************************************************/
/**********************************************************\
 *                                                        *
 * ConnectionHandler.java                                 *
 *                                                        *
 * hprose ConnectionHandler interface for Java.           *
 *                                                        *
 * LastModified: Apr 15, 2016                             *
 * Author: Ma Bingyao <andot@hprose.com>                  *
 *                                                        *
\**********************************************************/
package hprose.net;

import java.nio.ByteBuffer;

public interface ConnectionHandler {
    void onConnected(Connection conn);
    void onReceived(Connection conn, ByteBuffer data, Integer id);
    void onSended(Connection conn, Integer id);
    void onClose(Connection conn);
    void onError(Connection conn, Exception e);
    void onTimeout(Connection conn, TimeoutType type);
    long getReadTimeout();
    long getWriteTimeout();
    long getConnectTimeout();
}
