/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.client.Response;
import hprose.client.SocketTransporter;
import hprose.io.ByteBufferStream;
import hprose.net.Connection;
import hprose.net.ReceiveCallback;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Timer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;

final class FullDuplexSocketTransporter
extends SocketTransporter {
    private static final AtomicInteger nextId = new AtomicInteger(0);
    private final Map<Connection, Map<Integer, Response>> responses = new ConcurrentHashMap<Connection, Map<Integer, Response>>();
    private final Timer timer = new Timer(new Runnable(){

        public void run() {
            long currentTime = System.currentTimeMillis();
            for (Map.Entry entry : FullDuplexSocketTransporter.this.responses.entrySet()) {
                Connection conn = (Connection)entry.getKey();
                Map res = (Map)entry.getValue();
                Iterator it = res.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry e = it.next();
                    Response response = (Response)e.getValue();
                    if (currentTime - response.createTime < FullDuplexSocketTransporter.this.client.getTimeout()) continue;
                    it.remove();
                    response.callback.handler(null, new TimeoutException("timeout"));
                    if (!res.isEmpty()) continue;
                    conn.setTimeout(FullDuplexSocketTransporter.this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
                }
            }
        }
    });

    public FullDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
        this.timer.setInterval(client.getTimeout() + 1L >> 1);
    }

    private void recycle(Connection conn) {
        conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
    }

    protected final void send(Connection conn, ByteBufferStream stream, ReceiveCallback callback) {
        int id = nextId.getAndIncrement() & Integer.MAX_VALUE;
        this.responses.get(conn).put(id, new Response(callback));
        conn.send(stream.buffer, id);
    }

    public final void close() {
        this.timer.clear();
        for (Connection conn : this.responses.keySet()) {
            conn.close();
        }
    }

    public void onConnected(Connection conn) {
        this.responses.put(conn, new ConcurrentHashMap());
        Request request = (Request)this.requests.poll();
        if (request == null) {
            this.idleConnections.offer(conn);
            this.recycle(conn);
        } else {
            this.send(conn, request.stream, request.callback);
        }
    }

    public final void onTimeout(Connection conn, TimeoutType type) {
        block3: {
            block4: {
                block2: {
                    Request request;
                    if (TimeoutType.CONNECT_TIMEOUT != type) break block2;
                    while ((request = (Request)this.requests.poll()) != null) {
                        request.callback.handler(null, new TimeoutException("connect timeout"));
                    }
                    break block3;
                }
                if (TimeoutType.IDLE_TIMEOUT != type) break block4;
                this.idleConnections.remove(conn);
                break block3;
            }
            Map<Integer, Response> res = this.responses.get(conn);
            if (res == null) break block3;
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                Response response = entry.getValue();
                response.callback.handler(null, new TimeoutException(type.toString()));
                it.remove();
            }
        }
    }

    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Response response;
        Map<Integer, Response> res = this.responses.get(conn);
        if (res != null && (response = res.remove(id)) != null) {
            response.callback.handler(new ByteBufferStream(data), null);
        }
        if (res == null || res.isEmpty()) {
            this.recycle(conn);
        }
    }

    public final void onSended(Connection conn, Integer id) {
        Request request = (Request)this.requests.poll();
        if (request == null) {
            this.idleConnections.offer(conn);
        } else {
            this.send(conn, request.stream, request.callback);
        }
    }

    public final void onClose(Connection conn) {
        this.size.decrementAndGet();
        this.idleConnections.remove(conn);
        this.responses.remove(conn);
    }

    public final void onError(Connection conn, Exception e) {
        Map<Integer, Response> res = this.responses.get(conn);
        if (res != null) {
            Iterator<Map.Entry<Integer, Response>> it = res.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<Integer, Response> entry = it.next();
                Response response = entry.getValue();
                response.callback.handler(null, e);
                it.remove();
            }
        }
    }
}

