/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.client.Response;
import hprose.client.SocketTransporter;
import hprose.io.ByteBufferStream;
import hprose.net.Connection;
import hprose.net.ReceiveCallback;
import hprose.net.TimeoutType;
import hprose.util.concurrent.Timer;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;

final class HalfDuplexSocketTransporter
extends SocketTransporter {
    private final Map<Connection, Response> responses = new ConcurrentHashMap<Connection, Response>();
    private final Timer timer = new Timer(new Runnable(){

        public void run() {
            long currentTime = System.currentTimeMillis();
            Iterator it = HalfDuplexSocketTransporter.this.responses.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Connection conn = (Connection)entry.getKey();
                Response response = (Response)entry.getValue();
                if (currentTime - response.createTime < HalfDuplexSocketTransporter.this.client.getTimeout()) continue;
                it.remove();
                response.callback.handler(null, new TimeoutException("timeout"));
                conn.close();
            }
        }
    });

    public HalfDuplexSocketTransporter(HproseTcpClient client) {
        super(client);
        this.timer.setInterval(client.getTimeout() + 1L >> 1);
    }

    private void recycle(Connection conn) {
        this.idleConnections.offer(conn);
        conn.setTimeout(this.client.getIdleTimeout(), TimeoutType.IDLE_TIMEOUT);
    }

    protected final void send(Connection conn, ByteBufferStream stream, ReceiveCallback callback) {
        this.responses.put(conn, new Response(callback));
        conn.send(stream.buffer, null);
    }

    public final void close() {
        this.timer.clear();
        Iterator<Connection> it = this.responses.keySet().iterator();
        while (it.hasNext()) {
            it.next().close();
        }
        this.responses.clear();
    }

    public void onConnected(Connection conn) {
        Request request = (Request)this.requests.poll();
        if (request == null) {
            this.recycle(conn);
        } else {
            this.send(conn, request.stream, request.callback);
        }
    }

    public final void onTimeout(Connection conn, TimeoutType type) {
        if (TimeoutType.CONNECT_TIMEOUT == type) {
            Request request;
            while ((request = (Request)this.requests.poll()) != null) {
                request.callback.handler(null, new TimeoutException("connect timeout"));
            }
        } else if (TimeoutType.IDLE_TIMEOUT == type) {
            this.idleConnections.remove(conn);
        } else {
            Response response = this.responses.remove(conn);
            if (response != null) {
                response.callback.handler(null, new TimeoutException(type.toString()));
            }
        }
    }

    public final void onReceived(Connection conn, ByteBuffer data, Integer id) {
        Response response = this.responses.remove(conn);
        this.onConnected(conn);
        if (response != null) {
            response.callback.handler(new ByteBufferStream(data), null);
        }
    }

    public final void onSended(Connection conn, Integer id) {
    }

    public final void onClose(Connection conn) {
        this.size.decrementAndGet();
        this.idleConnections.remove(conn);
        this.responses.remove(conn);
    }

    public final void onError(Connection conn, Exception e) {
        Response response = this.responses.remove(conn);
        if (response != null) {
            response.callback.handler(null, e);
        }
    }
}

