/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.ClientContext;
import hprose.client.HproseHttpClient;
import hprose.client.HproseTcpClient;
import hprose.common.HproseCallback;
import hprose.common.HproseCallback1;
import hprose.common.HproseContext;
import hprose.common.HproseErrorEvent;
import hprose.common.HproseException;
import hprose.common.HproseFilter;
import hprose.common.HproseInvocationHandler;
import hprose.common.HproseInvoker;
import hprose.common.HproseResultMode;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.net.ReceiveCallback;
import hprose.util.ClassUtil;
import hprose.util.StrUtil;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class HproseClient
implements HproseInvoker {
    protected static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final Object[] nullArgs = new Object[0];
    private final ArrayList<HproseFilter> filters = new ArrayList();
    private HproseMode mode;
    protected String uri;
    public HproseErrorEvent onError = null;
    private static final HashMap<String, Class<? extends HproseClient>> clientFactories;

    protected HproseClient() {
        this(null, HproseMode.MemberMode);
    }

    protected HproseClient(String uri) {
        this(uri, HproseMode.MemberMode);
    }

    protected HproseClient(HproseMode mode) {
        this(null, mode);
    }

    protected HproseClient(String uri, HproseMode mode) {
        this.mode = mode;
        this.uri = uri;
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerClientFactory(String scheme, Class<? extends HproseClient> clientClass) {
        HashMap<String, Class<? extends HproseClient>> hashMap = clientFactories;
        synchronized (hashMap) {
            clientFactories.put(scheme, clientClass);
        }
    }

    public static HproseClient create(String uri) throws IOException, URISyntaxException {
        return HproseClient.create(uri, HproseMode.MemberMode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uri).getScheme().toLowerCase();
        Class<? extends HproseClient> clientClass = clientFactories.get(scheme);
        if (clientClass != null) {
            try {
                HproseClient client = clientClass.newInstance();
                client.mode = mode;
                client.uri = uri;
                return client;
            }
            catch (Exception ex) {
                throw new HproseException("This client doesn't support " + scheme + " scheme.");
            }
        }
        throw new HproseException("This client doesn't support " + scheme + " scheme.");
    }

    public HproseFilter getFilter() {
        if (this.filters.isEmpty()) {
            return null;
        }
        return this.filters.get(0);
    }

    public void setFilter(HproseFilter filter) {
        if (!this.filters.isEmpty()) {
            this.filters.clear();
        }
        if (filter != null) {
            this.filters.add(filter);
        }
    }

    public void addFilter(HproseFilter filter) {
        this.filters.add(filter);
    }

    public boolean removeFilter(HproseFilter filter) {
        return this.filters.remove(filter);
    }

    public void useService(String uri) {
        this.uri = uri;
    }

    public final <T> T useService(Class<T> type) {
        return this.useService(type, null);
    }

    public final <T> T useService(String uri, Class<T> type) {
        return this.useService(uri, type, null);
    }

    public final <T> T useService(Class<T> type, String ns) {
        HproseInvocationHandler handler = new HproseInvocationHandler(this, ns);
        if (type.isInterface()) {
            return (T)Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type}, (InvocationHandler)handler);
        }
        return (T)Proxy.newProxyInstance(type.getClassLoader(), type.getInterfaces(), (InvocationHandler)handler);
    }

    public final <T> T useService(String uri, Class<T> type, String ns) {
        this.useService(uri);
        return this.useService(type, ns);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback) {
        this.invoke(functionName, nullArgs, callback, null, (Type)null, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(functionName, nullArgs, callback, errorEvent, (Type)null, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseResultMode resultMode) {
        this.invoke(functionName, nullArgs, callback, null, (Type)null, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode) {
        this.invoke(functionName, nullArgs, callback, errorEvent, (Type)null, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, boolean simple) {
        this.invoke(functionName, nullArgs, callback, null, (Type)null, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseErrorEvent errorEvent, boolean simple) {
        this.invoke(functionName, nullArgs, callback, errorEvent, (Type)null, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, nullArgs, callback, null, (Type)null, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, HproseCallback1<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, nullArgs, callback, errorEvent, (Type)null, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback) {
        this.invoke(functionName, arguments, callback, null, (Type)null, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, null, (Type)null, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, boolean simple) {
        this.invoke(functionName, arguments, callback, null, (Type)null, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseErrorEvent errorEvent, boolean simple) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, null, (Type)null, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback1<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, Class<T> returnType) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, null, (Type)returnType, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, errorEvent, (Type)returnType, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, null, (Type)returnType, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, errorEvent, (Type)returnType, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, Class<T> returnType, boolean simple) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, null, (Type)returnType, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean simple) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, errorEvent, (Type)returnType, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, null, (Type)returnType, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, nullArgs, (HproseCallback1)callback, errorEvent, (Type)returnType, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, Class<T> returnType) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, null, (Type)returnType, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, errorEvent, (Type)returnType, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, null, (Type)returnType, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, errorEvent, (Type)returnType, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, Class<T> returnType, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, null, (Type)returnType, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, errorEvent, (Type)returnType, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, null, (Type)returnType, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback1<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback1)callback, errorEvent, (Type)returnType, resultMode, simple);
    }

    @Override
    public void invoke(final String functionName, final Object[] arguments, final HproseCallback1 callback, final HproseErrorEvent errorEvent, final Type returnType, final HproseResultMode resultMode, boolean simple) {
        try {
            final ClientContext context = new ClientContext(this);
            final ByteBufferStream ostream = this.doOutput(functionName, arguments, false, simple, context);
            this.send(ostream, new ReceiveCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handler(ByteBufferStream istream, Exception e) {
                    if (e != null) {
                        if (istream != null) {
                            istream.close();
                        }
                        HproseClient.this.fireErrorEvent(errorEvent, functionName, e);
                        return;
                    }
                    try {
                        Object result = HproseClient.this.doInput(istream, arguments, returnType, resultMode, context);
                        if (result instanceof HproseException) {
                            HproseClient.this.fireErrorEvent(errorEvent, functionName, (HproseException)result);
                        } else {
                            callback.handler(result);
                        }
                    }
                    catch (Exception ex) {
                        HproseClient.this.fireErrorEvent(errorEvent, functionName, ex);
                    }
                    finally {
                        if (istream != null) {
                            istream.close();
                        }
                        if (ostream != null) {
                            ostream.close();
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            this.fireErrorEvent(errorEvent, functionName, ex);
        }
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback) {
        this.invoke(functionName, arguments, callback, null, (Type)null, false, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, false, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, boolean byRef) {
        this.invoke(functionName, arguments, callback, null, (Type)null, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, boolean byRef) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, boolean byRef, boolean simple) {
        this.invoke(functionName, arguments, callback, null, (Type)null, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, boolean byRef, boolean simple) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, null, (Type)null, false, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, false, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, boolean byRef, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, null, (Type)null, byRef, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, boolean byRef, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, byRef, resultMode, false);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, null, (Type)null, false, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, false, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, boolean byRef, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, null, (Type)null, byRef, resultMode, simple);
    }

    @Override
    public final void invoke(String functionName, Object[] arguments, HproseCallback<?> callback, HproseErrorEvent errorEvent, boolean byRef, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, callback, errorEvent, (Type)null, byRef, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, false, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, false, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, boolean byRef) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean byRef) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, boolean byRef, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean byRef, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, false, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, false, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, boolean byRef, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, byRef, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean byRef, HproseResultMode resultMode) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, byRef, resultMode, false);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, false, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, false, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, Class<T> returnType, boolean byRef, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, null, (Type)returnType, byRef, resultMode, simple);
    }

    @Override
    public final <T> void invoke(String functionName, Object[] arguments, HproseCallback<T> callback, HproseErrorEvent errorEvent, Class<T> returnType, boolean byRef, HproseResultMode resultMode, boolean simple) {
        this.invoke(functionName, arguments, (HproseCallback)callback, errorEvent, (Type)returnType, byRef, resultMode, simple);
    }

    @Override
    public void invoke(final String functionName, final Object[] arguments, final HproseCallback callback, final HproseErrorEvent errorEvent, final Type returnType, boolean byRef, final HproseResultMode resultMode, boolean simple) {
        try {
            final ClientContext context = new ClientContext(this);
            final ByteBufferStream ostream = this.doOutput(functionName, arguments, byRef, simple, context);
            this.send(ostream, new ReceiveCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void handler(ByteBufferStream istream, Exception e) {
                    if (e != null) {
                        if (istream != null) {
                            istream.close();
                        }
                        HproseClient.this.fireErrorEvent(errorEvent, functionName, e);
                        return;
                    }
                    try {
                        Object result = HproseClient.this.doInput(istream, arguments, returnType, resultMode, context);
                        if (result instanceof HproseException) {
                            HproseClient.this.fireErrorEvent(errorEvent, functionName, (HproseException)result);
                        } else {
                            callback.handler(result, arguments);
                        }
                    }
                    catch (Exception ex) {
                        HproseClient.this.fireErrorEvent(errorEvent, functionName, ex);
                    }
                    finally {
                        if (istream != null) {
                            istream.close();
                        }
                        if (ostream != null) {
                            ostream.close();
                        }
                    }
                }
            });
        }
        catch (IOException ex) {
            this.fireErrorEvent(errorEvent, functionName, ex);
        }
    }

    private void fireErrorEvent(HproseErrorEvent errorEvent, String functionName, Throwable ex) {
        if (errorEvent != null) {
            errorEvent.handler(functionName, ex);
        } else if (this.onError != null) {
            this.onError.handler(functionName, ex);
        }
    }

    @Override
    public final Object invoke(String functionName) throws IOException {
        return this.invoke(functionName, nullArgs, (Type)null, false, HproseResultMode.Normal, false);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, false, HproseResultMode.Normal, false);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, boolean byRef) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final Object invoke(String functionName, boolean simple) throws IOException {
        return this.invoke(functionName, nullArgs, (Type)null, false, HproseResultMode.Normal, simple);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, boolean byRef, boolean simple) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final Object invoke(String functionName, HproseResultMode resultMode) throws IOException {
        return this.invoke(functionName, nullArgs, (Type)null, false, resultMode, false);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, HproseResultMode resultMode) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, false, resultMode, false);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, boolean byRef, HproseResultMode resultMode) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, byRef, resultMode, false);
    }

    @Override
    public final Object invoke(String functionName, HproseResultMode resultMode, boolean simple) throws IOException {
        return this.invoke(functionName, nullArgs, (Type)null, false, resultMode, simple);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, HproseResultMode resultMode, boolean simple) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, false, resultMode, simple);
    }

    @Override
    public final Object invoke(String functionName, Object[] arguments, boolean byRef, HproseResultMode resultMode, boolean simple) throws IOException {
        return this.invoke(functionName, arguments, (Type)null, byRef, resultMode, simple);
    }

    @Override
    public final <T> T invoke(String functionName, Class<T> returnType) throws IOException {
        return (T)this.invoke(functionName, nullArgs, (Type)returnType, false, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, false, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, boolean byRef) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, byRef, HproseResultMode.Normal, false);
    }

    @Override
    public final <T> T invoke(String functionName, Class<T> returnType, boolean simple) throws IOException {
        return (T)this.invoke(functionName, nullArgs, (Type)returnType, false, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, boolean byRef, boolean simple) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, byRef, HproseResultMode.Normal, simple);
    }

    @Override
    public final <T> T invoke(String functionName, Class<T> returnType, HproseResultMode resultMode) throws IOException {
        return (T)this.invoke(functionName, nullArgs, (Type)returnType, false, resultMode, false);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, HproseResultMode resultMode) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, false, resultMode, false);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, boolean byRef, HproseResultMode resultMode) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, byRef, resultMode, false);
    }

    @Override
    public final <T> T invoke(String functionName, Class<T> returnType, HproseResultMode resultMode, boolean simple) throws IOException {
        return (T)this.invoke(functionName, nullArgs, (Type)returnType, false, resultMode, simple);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, HproseResultMode resultMode, boolean simple) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, false, resultMode, simple);
    }

    @Override
    public final <T> T invoke(String functionName, Object[] arguments, Class<T> returnType, boolean byRef, HproseResultMode resultMode, boolean simple) throws IOException {
        return (T)this.invoke(functionName, arguments, (Type)returnType, byRef, resultMode, simple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(final String functionName, final Object[] arguments, Type returnType, final boolean byRef, final HproseResultMode resultMode, final boolean simple) throws IOException {
        if (Future.class.equals(ClassUtil.toClass(returnType))) {
            if (returnType instanceof ParameterizedType) {
                if (Void.TYPE.equals(returnType = ((ParameterizedType)returnType).getActualTypeArguments()[0]) || Void.class.equals((Object)returnType)) {
                    returnType = null;
                }
            } else {
                returnType = null;
            }
            final Type _returnType = returnType;
            return executor.submit(new Callable<Object>(){

                @Override
                public Object call() throws Exception {
                    return HproseClient.this.invoke(functionName, arguments, _returnType, byRef, resultMode, simple);
                }
            });
        }
        ByteBufferStream ostream = null;
        ByteBufferStream istream = null;
        try {
            ClientContext context = new ClientContext(this);
            ostream = this.doOutput(functionName, arguments, byRef, simple, context);
            istream = this.sendAndReceive(ostream);
            Object result = this.doInput(istream, arguments, returnType, resultMode, context);
            if (result instanceof HproseException) {
                throw (HproseException)result;
            }
            Object object = result;
            return object;
        }
        finally {
            if (ostream != null) {
                ostream.close();
            }
            if (istream != null) {
                istream.close();
            }
        }
    }

    private ByteBufferStream doOutput(String functionName, Object[] arguments, boolean byRef, boolean simple, HproseContext context) throws IOException {
        ByteBufferStream stream = new ByteBufferStream();
        Writer hproseWriter = new Writer(stream.getOutputStream(), this.mode, simple);
        stream.write(67);
        hproseWriter.writeString(functionName);
        if (arguments != null && (arguments.length > 0 || byRef)) {
            hproseWriter.reset();
            hproseWriter.writeArray(arguments);
            if (byRef) {
                hproseWriter.writeBoolean(true);
            }
        }
        stream.write(122);
        stream.flip();
        int n = this.filters.size();
        for (int i = 0; i < n; ++i) {
            stream.buffer = this.filters.get(i).outputFilter(stream.buffer, context);
            stream.flip();
        }
        return stream;
    }

    private Object ByteBufferStreamToType(ByteBufferStream stream, Type returnType) throws HproseException {
        stream.flip();
        if (returnType == null || returnType == Object.class || returnType == ByteBuffer.class || returnType == Buffer.class) {
            return stream.buffer;
        }
        if (returnType == ByteBufferStream.class) {
            return stream;
        }
        if (returnType == byte[].class) {
            byte[] bytes = stream.toArray();
            stream.close();
            return bytes;
        }
        throw new HproseException("Can't Convert ByteBuffer to Type: " + returnType.toString());
    }

    private Object doInput(ByteBufferStream stream, Object[] arguments, Type returnType, HproseResultMode resultMode, HproseContext context) throws IOException {
        stream.flip();
        for (int i = this.filters.size() - 1; i >= 0; --i) {
            stream.buffer = this.filters.get(i).inputFilter(stream.buffer, context);
            stream.flip();
        }
        int tag = stream.buffer.get(stream.buffer.limit() - 1);
        if (tag != 122) {
            throw new HproseException("Wrong Response: \r\n" + StrUtil.toString(stream));
        }
        if (resultMode == HproseResultMode.Raw) {
            stream.buffer.limit(stream.buffer.limit() - 1);
        }
        if (resultMode == HproseResultMode.RawWithEndTag || resultMode == HproseResultMode.Raw) {
            return this.ByteBufferStreamToType(stream, returnType);
        }
        Object result = null;
        Reader hproseReader = new Reader(stream.getInputStream(), this.mode);
        block6: while ((tag = stream.read()) != 122) {
            switch (tag) {
                case 82: {
                    if (resultMode == HproseResultMode.Normal) {
                        hproseReader.reset();
                        result = hproseReader.unserialize(returnType);
                        continue block6;
                    }
                    if (resultMode != HproseResultMode.Serialized) continue block6;
                    result = this.ByteBufferStreamToType(hproseReader.readRaw(), returnType);
                    continue block6;
                }
                case 65: {
                    hproseReader.reset();
                    Object[] args = hproseReader.readObjectArray();
                    int length = arguments.length;
                    if (length > args.length) {
                        length = args.length;
                    }
                    System.arraycopy(args, 0, arguments, 0, length);
                    continue block6;
                }
                case 69: {
                    hproseReader.reset();
                    result = new HproseException(hproseReader.readString());
                    continue block6;
                }
            }
            stream.rewind();
            throw new HproseException("Wrong Response: \r\n" + StrUtil.toString(stream));
        }
        return result;
    }

    protected abstract ByteBufferStream sendAndReceive(ByteBufferStream var1) throws IOException;

    protected abstract void send(ByteBufferStream var1, ReceiveCallback var2) throws IOException;

    static {
        Threads.registerShutdownHandler(new Runnable(){

            public void run() {
                if (!executor.isShutdown()) {
                    executor.shutdown();
                }
            }
        });
        clientFactories = new HashMap();
        HproseClient.registerClientFactory("tcp", HproseTcpClient.class);
        HproseClient.registerClientFactory("tcp4", HproseTcpClient.class);
        HproseClient.registerClientFactory("tcp6", HproseTcpClient.class);
        HproseClient.registerClientFactory("http", HproseHttpClient.class);
        HproseClient.registerClientFactory("https", HproseHttpClient.class);
    }
}

