/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.CookieManager;
import hprose.client.HproseClient;
import hprose.common.HproseException;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.net.ReceiveCallback;
import hprose.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public class HproseHttpClient
extends HproseClient {
    private final ConcurrentHashMap<String, String> headers = new ConcurrentHashMap();
    private static boolean disableGlobalCookie = false;
    private static CookieManager globalCookieManager = new CookieManager();
    private final CookieManager cookieManager = disableGlobalCookie ? new CookieManager() : globalCookieManager;
    private boolean keepAlive = true;
    private int keepAliveTimeout = 300;
    private String proxyHost = null;
    private int proxyPort = 80;
    private String proxyUser = null;
    private String proxyPass = null;
    private int timeout = 0;
    private HostnameVerifier hv = null;
    private SSLSocketFactory sslsf = null;

    public static void setDisableGlobalCookie(boolean value) {
        disableGlobalCookie = value;
    }

    public static boolean isDisableGlobalCookie() {
        return disableGlobalCookie;
    }

    public HproseHttpClient() {
    }

    public HproseHttpClient(String uri) {
        super(uri);
    }

    public HproseHttpClient(HproseMode mode) {
        super(mode);
    }

    public HproseHttpClient(String uri, HproseMode mode) {
        super(uri, mode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uri).getScheme().toLowerCase();
        if (!scheme.equals("http") && !scheme.equals("https")) {
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseHttpClient(uri, mode);
    }

    public void setHeader(String name, String value) {
        String nl = name.toLowerCase();
        if (!(nl.equals("content-type") || nl.equals("content-length") || nl.equals("connection") || nl.equals("keep-alive") || nl.equals("host"))) {
            if (value == null) {
                this.headers.remove(name);
            } else {
                this.headers.put(name, value);
            }
        }
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    public int getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public String getProxyPass() {
        return this.proxyPass;
    }

    public void setProxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public HostnameVerifier getHostnameVerifier() {
        return this.hv;
    }

    public void setHostnameVerifier(HostnameVerifier hv) {
        this.hv = hv;
    }

    public SSLSocketFactory getSSLSocketFactory() {
        return this.sslsf;
    }

    public void setSSLSocketFactory(SSLSocketFactory sslsf) {
        this.sslsf = sslsf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ByteBufferStream sendAndReceive(ByteBufferStream stream) throws IOException {
        String key;
        URL url = new URL(this.uri);
        Properties prop = System.getProperties();
        prop.put("http.keepAlive", Boolean.toString(this.keepAlive));
        if (this.proxyHost != null) {
            prop.put("http.proxyHost", this.proxyHost);
            prop.put("http.proxyPort", Integer.toString(this.proxyPort));
        } else {
            prop.remove("http.proxyHost");
            prop.remove("http.proxyPort");
        }
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (url.getProtocol().equals("https")) {
            if (this.hv != null) {
                ((HttpsURLConnection)conn).setHostnameVerifier(this.hv);
            }
            if (this.sslsf != null) {
                ((HttpsURLConnection)conn).setSSLSocketFactory(this.sslsf);
            }
        }
        conn.setConnectTimeout(this.timeout);
        conn.setReadTimeout(this.timeout);
        conn.setRequestProperty("Cookie", this.cookieManager.getCookie(url.getHost(), url.getFile(), url.getProtocol().equals("https")));
        if (this.keepAlive) {
            conn.setRequestProperty("Connection", "keep-alive");
            conn.setRequestProperty("Keep-Alive", Integer.toString(this.keepAliveTimeout));
        } else {
            conn.setRequestProperty("Connection", "close");
        }
        if (this.proxyUser != null && this.proxyPass != null) {
            conn.setRequestProperty("Proxy-Authorization", "Basic " + Base64.encode((this.proxyUser + ":" + this.proxyPass).getBytes()));
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            conn.setRequestProperty(entry.getKey(), entry.getValue());
        }
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setRequestProperty("Content-Type", "application/hprose");
        conn.setRequestProperty("Content-Length", Integer.toString(stream.available()));
        OutputStream ostream = null;
        try {
            ostream = conn.getOutputStream();
            stream.writeTo(ostream);
            ostream.flush();
        }
        finally {
            if (ostream != null) {
                ostream.close();
            }
        }
        ArrayList<String> cookieList = new ArrayList<String>();
        int i = 1;
        while ((key = conn.getHeaderFieldKey(i)) != null) {
            if (key.equalsIgnoreCase("set-cookie") || key.equalsIgnoreCase("set-cookie2")) {
                cookieList.add(conn.getHeaderField(i));
            }
            ++i;
        }
        this.cookieManager.setCookie(cookieList, url.getHost());
        InputStream istream = null;
        try {
            istream = conn.getInputStream();
            stream.buffer.clear();
            stream.readFrom(istream);
            ByteBufferStream byteBufferStream = stream;
            return byteBufferStream;
        }
        catch (IOException e) {
            InputStream estream = null;
            try {
                estream = conn.getErrorStream();
                if (estream != null) {
                    stream.buffer.clear();
                    stream.readFrom(estream);
                    ByteBufferStream byteBufferStream = stream;
                    return byteBufferStream;
                }
                throw e;
            }
            finally {
                if (estream != null) {
                    estream.close();
                }
            }
        }
        finally {
            if (istream != null) {
                istream.close();
            }
        }
    }

    protected void send(final ByteBufferStream buffer, final ReceiveCallback callback) throws IOException {
        executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ByteBufferStream istream = null;
                Exception e = null;
                try {
                    istream = HproseHttpClient.this.sendAndReceive(buffer);
                }
                catch (Exception ex) {
                    e = ex;
                }
                finally {
                    callback.handler(istream, e);
                }
            }
        });
    }
}

