/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.FullDuplexSocketTransporter;
import hprose.client.HalfDuplexSocketTransporter;
import hprose.client.HproseClient;
import hprose.client.Result;
import hprose.client.SocketTransporter;
import hprose.common.HproseException;
import hprose.io.ByteBufferStream;
import hprose.io.HproseMode;
import hprose.net.ReceiveCallback;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.Semaphore;

public class HproseTcpClient
extends HproseClient {
    private static int reactorThreads = Runtime.getRuntime().availableProcessors() + 1 >> 1;
    private volatile boolean fullDuplex = false;
    private volatile boolean noDelay = false;
    private volatile int maxPoolSize = 10;
    private volatile long idleTimeout = 30000L;
    private volatile long readTimeout = 30000L;
    private volatile long writeTimeout = 30000L;
    private volatile long connectTimeout = 30000L;
    private volatile long timeout = 30000L;
    private volatile boolean keepAlive = true;
    private volatile SocketTransporter fdTrans = null;
    private volatile SocketTransporter hdTrans = null;

    public static int getReactorThreads() {
        return reactorThreads;
    }

    public static void setReactorThreads(int aReactorThreads) {
        reactorThreads = aReactorThreads;
    }

    public HproseTcpClient() {
    }

    public HproseTcpClient(String uri) {
        super(uri);
    }

    public HproseTcpClient(HproseMode mode) {
        super(mode);
    }

    public HproseTcpClient(String uri, HproseMode mode) {
        super(uri, mode);
    }

    public static HproseClient create(String uri, HproseMode mode) throws IOException, URISyntaxException {
        String scheme = new URI(uri).getScheme().toLowerCase();
        if (!(scheme.equals("tcp") || scheme.equals("tcp4") || scheme.equals("tcp6"))) {
            throw new HproseException("This client doesn't support " + scheme + " scheme.");
        }
        return new HproseTcpClient(uri, mode);
    }

    public final void close() {
        if (this.fdTrans != null) {
            this.fdTrans.close();
        }
        if (this.hdTrans != null) {
            this.hdTrans.close();
        }
        super.close();
    }

    public final boolean isFullDuplex() {
        return this.fullDuplex;
    }

    public final void setFullDuplex(boolean fullDuplex) {
        this.fullDuplex = fullDuplex;
    }

    public final boolean isNoDelay() {
        return this.noDelay;
    }

    public final void setNoDelay(boolean noDelay) {
        this.noDelay = noDelay;
    }

    public final int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public final void setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 1) {
            throw new IllegalArgumentException("maxPoolSize must be great than 0");
        }
        this.maxPoolSize = maxPoolSize;
    }

    public final long getIdleTimeout() {
        return this.idleTimeout;
    }

    public final void setIdleTimeout(long idleTimeout) {
        if (idleTimeout < 0L) {
            throw new IllegalArgumentException("idleTimeout must be great than -1");
        }
        this.idleTimeout = idleTimeout;
    }

    public final long getReadTimeout() {
        return this.readTimeout;
    }

    public final void setReadTimeout(long readTimeout) {
        if (readTimeout < 1L) {
            throw new IllegalArgumentException("readTimeout must be great than 0");
        }
        this.readTimeout = readTimeout;
    }

    public final long getWriteTimeout() {
        return this.writeTimeout;
    }

    public final void setWriteTimeout(long writeTimeout) {
        if (writeTimeout < 1L) {
            throw new IllegalArgumentException("writeTimeout must be great than 0");
        }
        this.writeTimeout = writeTimeout;
    }

    public final long getConnectTimeout() {
        return this.connectTimeout;
    }

    public final void setConnectTimeout(long connectTimeout) {
        if (connectTimeout < 1L) {
            throw new IllegalArgumentException("connectTimeout must be great than 0");
        }
        this.connectTimeout = connectTimeout;
    }

    public final long getTimeout() {
        return this.timeout;
    }

    public final void setTimeout(long timeout) {
        if (timeout < 1L) {
            throw new IllegalArgumentException("timeout must be great than 0");
        }
        this.timeout = timeout;
    }

    public final boolean isKeepAlive() {
        return this.keepAlive;
    }

    public final void setKeepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
    }

    protected final ByteBufferStream sendAndReceive(ByteBufferStream buffer) throws IOException {
        final Result result = new Result();
        final Semaphore sem = new Semaphore(0);
        this.send(buffer, new ReceiveCallback(){

            public void handler(ByteBufferStream istream, Exception e) {
                result.stream = istream;
                if (e != null) {
                    result.ex = e instanceof IOException ? (IOException)e : new HproseException(e.getMessage());
                }
                sem.release();
            }
        });
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        if (result.ex == null) {
            return result.stream;
        }
        throw result.ex;
    }

    protected final void send(ByteBufferStream buffer, ReceiveCallback callback) throws IOException {
        SocketTransporter trans;
        if (this.fullDuplex) {
            trans = this.fdTrans;
            if (trans == null) {
                trans = this.fdTrans = new FullDuplexSocketTransporter(this);
            }
        } else {
            trans = this.hdTrans;
            if (trans == null) {
                trans = this.hdTrans = new HalfDuplexSocketTransporter(this);
            }
        }
        trans.send(buffer, callback);
    }
}

