/*
 * Decompiled with CFR 0.152.
 */
package hprose.client;

import hprose.client.HproseTcpClient;
import hprose.client.Request;
import hprose.io.ByteBufferStream;
import hprose.net.Connection;
import hprose.net.ConnectionHandler;
import hprose.net.Connector;
import hprose.net.ReceiveCallback;
import hprose.util.concurrent.Threads;
import java.io.IOException;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;

abstract class SocketTransporter
implements ConnectionHandler {
    protected final HproseTcpClient client;
    protected final Queue<Connection> idleConnections = new ConcurrentLinkedQueue<Connection>();
    protected final Queue<Request> requests = new ConcurrentLinkedQueue<Request>();
    protected final AtomicInteger size = new AtomicInteger(0);

    public SocketTransporter(HproseTcpClient client) {
        this.client = client;
    }

    public final long getReadTimeout() {
        return this.client.getReadTimeout();
    }

    public final long getWriteTimeout() {
        return this.client.getWriteTimeout();
    }

    public final long getConnectTimeout() {
        return this.client.getConnectTimeout();
    }

    protected final Connection fetch() {
        Connection conn = this.idleConnections.poll();
        if (conn != null) {
            conn.clearTimeout();
        }
        return conn;
    }

    protected abstract void send(Connection var1, ByteBufferStream var2, ReceiveCallback var3);

    public final void send(ByteBufferStream stream, ReceiveCallback callback) throws IOException {
        Connection conn = this.fetch();
        if (conn != null) {
            this.send(conn, stream, callback);
        } else {
            if (this.size.getAndIncrement() < this.client.getMaxPoolSize()) {
                ConnectorHolder.connector.create(this.client.uri, this, this.client.isKeepAlive(), this.client.isNoDelay());
            } else {
                this.size.getAndDecrement();
            }
            this.requests.offer(new Request(stream, callback));
        }
    }

    public abstract void close();

    protected static final class ConnectorHolder {
        static final Connector connector;

        protected ConnectorHolder() {
        }

        static {
            Connector temp = null;
            try {
                temp = new Connector(HproseTcpClient.getReactorThreads());
            }
            catch (IOException iOException) {
            }
            finally {
                connector = temp;
                connector.start();
            }
            Threads.registerShutdownHandler(new Runnable(){

                public void run() {
                    if (connector != null) {
                        connector.close();
                    }
                }
            });
        }
    }
}

