/*
 * Decompiled with CFR 0.152.
 */
package hprose.common;

import hprose.common.ByRef;
import hprose.common.HproseCallback;
import hprose.common.HproseCallback1;
import hprose.common.HproseErrorEvent;
import hprose.common.HproseInvoker;
import hprose.common.HproseResultMode;
import hprose.common.MethodName;
import hprose.common.ResultMode;
import hprose.common.SimpleMode;
import hprose.util.ClassUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class HproseInvocationHandler
implements InvocationHandler {
    private final HproseInvoker client;
    private final String ns;

    public HproseInvocationHandler(HproseInvoker client, String ns) {
        this.client = client;
        this.ns = ns == null ? "" : ns + "_";
    }

    public Object invoke(Object proxy, Method method, Object[] arguments) throws Throwable {
        MethodName methodName = method.getAnnotation(MethodName.class);
        String functionName = this.ns + (methodName == null ? method.getName() : methodName.value());
        ResultMode rm = method.getAnnotation(ResultMode.class);
        HproseResultMode resultMode = rm == null ? HproseResultMode.Normal : rm.value();
        SimpleMode sm = method.getAnnotation(SimpleMode.class);
        boolean simple = sm == null ? false : sm.value();
        ByRef byref = method.getAnnotation(ByRef.class);
        boolean byRef = byref == null ? false : byref.value();
        Type[] paramTypes = method.getGenericParameterTypes();
        Type returnType = method.getGenericReturnType();
        if (Void.TYPE.equals(returnType) || Void.class.equals((Object)returnType)) {
            returnType = null;
        }
        int n = paramTypes.length;
        Object result = null;
        if (n > 0 && ClassUtil.toClass(paramTypes[n - 1]).equals(HproseCallback1.class)) {
            if (paramTypes[n - 1] instanceof ParameterizedType) {
                returnType = ((ParameterizedType)paramTypes[n - 1]).getActualTypeArguments()[0];
            }
            HproseCallback1 callback = (HproseCallback1)arguments[n - 1];
            Object[] tmpargs = new Object[n - 1];
            System.arraycopy(arguments, 0, tmpargs, 0, n - 1);
            this.client.invoke(functionName, tmpargs, callback, null, returnType, resultMode, simple);
        } else if (n > 0 && ClassUtil.toClass(paramTypes[n - 1]).equals(HproseCallback.class)) {
            if (paramTypes[n - 1] instanceof ParameterizedType) {
                returnType = ((ParameterizedType)paramTypes[n - 1]).getActualTypeArguments()[0];
            }
            HproseCallback callback = (HproseCallback)arguments[n - 1];
            Object[] tmpargs = new Object[n - 1];
            System.arraycopy(arguments, 0, tmpargs, 0, n - 1);
            this.client.invoke(functionName, tmpargs, callback, null, returnType, byRef, resultMode, simple);
        } else if (n > 1 && ClassUtil.toClass(paramTypes[n - 2]).equals(HproseCallback1.class) && ClassUtil.toClass(paramTypes[n - 1]).equals(HproseErrorEvent.class)) {
            if (paramTypes[n - 2] instanceof ParameterizedType) {
                returnType = ((ParameterizedType)paramTypes[n - 2]).getActualTypeArguments()[0];
            }
            HproseCallback1 callback = (HproseCallback1)arguments[n - 2];
            HproseErrorEvent errorEvent = (HproseErrorEvent)arguments[n - 1];
            Object[] tmpargs = new Object[n - 2];
            System.arraycopy(arguments, 0, tmpargs, 0, n - 2);
            this.client.invoke(functionName, tmpargs, callback, errorEvent, returnType, resultMode, simple);
        } else if (n > 1 && ClassUtil.toClass(paramTypes[n - 2]).equals(HproseCallback.class) && ClassUtil.toClass(paramTypes[n - 1]).equals(HproseErrorEvent.class)) {
            if (paramTypes[n - 2] instanceof ParameterizedType) {
                returnType = ((ParameterizedType)paramTypes[n - 2]).getActualTypeArguments()[0];
            }
            HproseCallback callback = (HproseCallback)arguments[n - 2];
            HproseErrorEvent errorEvent = (HproseErrorEvent)arguments[n - 1];
            Object[] tmpargs = new Object[n - 2];
            System.arraycopy(arguments, 0, tmpargs, 0, n - 2);
            this.client.invoke(functionName, tmpargs, callback, errorEvent, returnType, byRef, resultMode, simple);
        } else {
            result = this.client.invoke(functionName, arguments, returnType, byRef, resultMode, simple);
        }
        return result;
    }
}

