/*
 * Decompiled with CFR 0.152.
 */
package hprose.common;

import hprose.common.HproseContext;
import hprose.common.HproseMethod;
import hprose.common.HproseResultMode;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HproseMethods {
    protected ConcurrentHashMap<String, ConcurrentHashMap<Integer, HproseMethod>> remoteMethods = new ConcurrentHashMap();
    protected ConcurrentHashMap<String, String> methodNames = new ConcurrentHashMap();

    public HproseMethod get(String aliasName, int paramCount) {
        ConcurrentHashMap<Integer, HproseMethod> methods = this.remoteMethods.get(aliasName);
        if (methods == null) {
            return null;
        }
        return methods.get(paramCount);
    }

    public Collection<String> getAllNames() {
        return this.methodNames.values();
    }

    public int getCount() {
        return this.remoteMethods.size();
    }

    protected int getCount(Type[] paramTypes) {
        Class paramType;
        int i = paramTypes.length;
        if (i > 0 && paramTypes[i - 1] instanceof Class && (paramType = (Class)paramTypes[i - 1]).equals(HproseContext.class)) {
            --i;
        }
        return i;
    }

    void addMethod(String aliasName, HproseMethod method) {
        ConcurrentHashMap<Object, Object> methods;
        String name = aliasName.toLowerCase();
        if (this.remoteMethods.containsKey(name)) {
            methods = this.remoteMethods.get(name);
        } else {
            methods = new ConcurrentHashMap();
            this.methodNames.put(name, aliasName);
        }
        if (!(!aliasName.equals("*") || method.paramTypes.length == 2 && method.paramTypes[0].equals(String.class) && method.paramTypes[1].equals(Object[].class))) {
            return;
        }
        int i = this.getCount(method.paramTypes);
        methods.put(i, method);
        this.remoteMethods.put(name, methods);
    }

    public void addMethod(Method method, Object obj, String aliasName) {
        this.addMethod(aliasName, new HproseMethod(method, obj));
    }

    public void addMethod(Method method, Object obj, String aliasName, HproseResultMode mode) {
        this.addMethod(aliasName, new HproseMethod(method, obj, mode));
    }

    public void addMethod(Method method, Object obj, String aliasName, boolean simple) {
        this.addMethod(aliasName, new HproseMethod(method, obj, simple));
    }

    public void addMethod(Method method, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(aliasName, new HproseMethod(method, obj, mode, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, mode));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, obj, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, mode));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, String aliasName, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(aliasName, new HproseMethod(methodName, type, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, obj, paramTypes));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, obj, paramTypes, mode));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, obj, paramTypes, simple));
    }

    public void addMethod(String methodName, Object obj, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, obj, paramTypes, mode, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, type, paramTypes));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, type, paramTypes, mode));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, type, paramTypes, simple));
    }

    public void addMethod(String methodName, Class<?> type, Class<?>[] paramTypes, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, new HproseMethod(methodName, type, paramTypes, mode, simple));
    }

    private void addMethod(String methodName, Object obj, Class<?> type, String aliasName, HproseResultMode mode, boolean simple) {
        Method[] methods;
        for (Method method : methods = type.getMethods()) {
            if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
            this.addMethod(aliasName, new HproseMethod(method, obj, mode, simple));
        }
    }

    private void addMethod(String methodName, Object obj, Class<?> type, String aliasName) {
        this.addMethod(methodName, obj, type, aliasName, HproseResultMode.Normal, false);
    }

    public void addMethod(String methodName, Object obj, String aliasName) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName);
    }

    public void addMethod(String methodName, Object obj, String aliasName, HproseResultMode mode) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, mode, false);
    }

    public void addMethod(String methodName, Object obj, String aliasName, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, HproseResultMode.Normal, simple);
    }

    public void addMethod(String methodName, Object obj, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, obj, obj.getClass(), aliasName, mode, simple);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName) {
        this.addMethod(methodName, null, type, aliasName);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, HproseResultMode mode) {
        this.addMethod(methodName, null, type, aliasName, mode, false);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, boolean simple) {
        this.addMethod(methodName, null, type, aliasName, HproseResultMode.Normal, simple);
    }

    public void addMethod(String methodName, Class<?> type, String aliasName, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, null, type, aliasName, mode, simple);
    }

    public void addMethod(String methodName, Object obj) {
        this.addMethod(methodName, obj, methodName);
    }

    public void addMethod(String methodName, Object obj, HproseResultMode mode) {
        this.addMethod(methodName, obj, methodName, mode, false);
    }

    public void addMethod(String methodName, Object obj, boolean simple) {
        this.addMethod(methodName, obj, methodName, HproseResultMode.Normal, simple);
    }

    public void addMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, obj, methodName, mode, simple);
    }

    public void addMethod(String methodName, Class<?> type) {
        this.addMethod(methodName, type, methodName);
    }

    public void addMethod(String methodName, Class<?> type, HproseResultMode mode) {
        this.addMethod(methodName, type, methodName, mode, false);
    }

    public void addMethod(String methodName, Class<?> type, boolean simple) {
        this.addMethod(methodName, type, methodName, HproseResultMode.Normal, simple);
    }

    public void addMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) {
        this.addMethod(methodName, type, methodName, mode, simple);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple) {
        Method[] methods = type.getMethods();
        for (int i = 0; i < methodNames.length; ++i) {
            String methodName = methodNames[i];
            String aliasName = aliasNames[i];
            for (Method method : methods) {
                if (!methodName.equals(method.getName()) || obj == null != Modifier.isStatic(method.getModifiers())) continue;
                this.addMethod(aliasName, new HproseMethod(method, obj, mode, simple));
            }
        }
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String[] aliasNames) {
        this.addMethods(methodNames, obj, type, aliasNames, HproseResultMode.Normal, false);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        String[] aliasNames = new String[methodNames.length];
        for (int i = 0; i < methodNames.length; ++i) {
            aliasNames[i] = aliasPrefix + "_" + methodNames[i];
        }
        this.addMethods(methodNames, obj, type, aliasNames, mode, simple);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, String aliasPrefix) {
        this.addMethods(methodNames, obj, type, aliasPrefix, HproseResultMode.Normal, false);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, type, methodNames, mode, simple);
    }

    private void addMethods(String[] methodNames, Object obj, Class<?> type) {
        this.addMethods(methodNames, obj, type, methodNames, HproseResultMode.Normal, false);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, mode, false);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasNames, mode, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, mode, false);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), aliasPrefix, mode, simple);
    }

    public void addMethods(String[] methodNames, Object obj) {
        this.addMethods(methodNames, obj, obj.getClass());
    }

    public void addMethods(String[] methodNames, Object obj, HproseResultMode mode) {
        this.addMethods(methodNames, obj, obj.getClass(), mode, false);
    }

    public void addMethods(String[] methodNames, Object obj, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Object obj, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, obj, obj.getClass(), mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames) {
        this.addMethods(methodNames, null, type, aliasNames);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, aliasNames, mode, false);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, boolean simple) {
        this.addMethods(methodNames, null, type, aliasNames, HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String[] aliasNames, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, aliasNames, mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix) {
        this.addMethods(methodNames, null, type, aliasPrefix);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, aliasPrefix, mode, false);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, boolean simple) {
        this.addMethods(methodNames, null, type, aliasPrefix, HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, aliasPrefix, mode, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type) {
        this.addMethods(methodNames, null, type);
    }

    public void addMethods(String[] methodNames, Class<?> type, HproseResultMode mode) {
        this.addMethods(methodNames, null, type, mode, false);
    }

    public void addMethods(String[] methodNames, Class<?> type, boolean simple) {
        this.addMethods(methodNames, null, type, HproseResultMode.Normal, simple);
    }

    public void addMethods(String[] methodNames, Class<?> type, HproseResultMode mode, boolean simple) {
        this.addMethods(methodNames, null, type, mode, simple);
    }

    public void addInstanceMethods(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        if (obj != null) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
                this.addMethod(method, obj, aliasPrefix + "_" + method.getName(), mode, simple);
            }
        }
    }

    public void addInstanceMethods(Object obj, Class<?> type, String aliasPrefix, boolean simple) {
        this.addInstanceMethods(obj, type, aliasPrefix, HproseResultMode.Normal, simple);
    }

    public void addInstanceMethods(Object obj, Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.addInstanceMethods(obj, type, aliasPrefix, mode, false);
    }

    public void addInstanceMethods(Object obj, Class<?> type, String aliasPrefix) {
        this.addInstanceMethods(obj, type, aliasPrefix, HproseResultMode.Normal, false);
    }

    public void addInstanceMethods(Object obj, Class<?> type, HproseResultMode mode, boolean simple) {
        if (obj != null) {
            Method[] methods;
            for (Method method : methods = type.getDeclaredMethods()) {
                int mod = method.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod)) continue;
                this.addMethod(method, obj, method.getName(), mode, simple);
            }
        }
    }

    public void addInstanceMethods(Object obj, Class<?> type, boolean simple) {
        this.addInstanceMethods(obj, type, HproseResultMode.Normal, simple);
    }

    public void addInstanceMethods(Object obj, Class<?> type, HproseResultMode mode) {
        this.addInstanceMethods(obj, type, mode, false);
    }

    public void addInstanceMethods(Object obj, Class<?> type) {
        this.addInstanceMethods(obj, type, HproseResultMode.Normal, false);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, HproseResultMode mode) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, mode);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, simple);
    }

    public void addInstanceMethods(Object obj, String aliasPrefix, HproseResultMode mode, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), aliasPrefix, mode, simple);
    }

    public void addInstanceMethods(Object obj) {
        this.addInstanceMethods(obj, obj.getClass());
    }

    public void addInstanceMethods(Object obj, HproseResultMode mode) {
        this.addInstanceMethods(obj, obj.getClass(), mode);
    }

    public void addInstanceMethods(Object obj, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), simple);
    }

    public void addInstanceMethods(Object obj, HproseResultMode mode, boolean simple) {
        this.addInstanceMethods(obj, obj.getClass(), mode, simple);
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, HproseResultMode mode, boolean simple) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            this.addMethod(method, null, aliasPrefix + "_" + method.getName(), mode, simple);
        }
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, boolean simple) {
        this.addStaticMethods(type, aliasPrefix, HproseResultMode.Normal, simple);
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix, HproseResultMode mode) {
        this.addStaticMethods(type, aliasPrefix, mode, false);
    }

    public void addStaticMethods(Class<?> type, String aliasPrefix) {
        this.addStaticMethods(type, aliasPrefix, HproseResultMode.Normal, false);
    }

    public void addStaticMethods(Class<?> type, HproseResultMode mode, boolean simple) {
        Method[] methods;
        for (Method method : methods = type.getDeclaredMethods()) {
            int mod = method.getModifiers();
            if (!Modifier.isPublic(mod) || !Modifier.isStatic(mod)) continue;
            this.addMethod(method, null, method.getName(), mode, simple);
        }
    }

    public void addStaticMethods(Class<?> type, boolean simple) {
        this.addStaticMethods(type, HproseResultMode.Normal, simple);
    }

    public void addStaticMethods(Class<?> type, HproseResultMode mode) {
        this.addStaticMethods(type, mode, false);
    }

    public void addStaticMethods(Class<?> type) {
        this.addStaticMethods(type, HproseResultMode.Normal, false);
    }

    public void addMissingMethod(String methodName, Object obj) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*");
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", mode);
    }

    public void addMissingMethod(String methodName, Object obj, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", simple);
    }

    public void addMissingMethod(String methodName, Object obj, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, obj, new Class[]{String.class, Object[].class}, "*", mode, simple);
    }

    public void addMissingMethod(String methodName, Class<?> type) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*");
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", mode);
    }

    public void addMissingMethod(String methodName, Class<?> type, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", simple);
    }

    public void addMissingMethod(String methodName, Class<?> type, HproseResultMode mode, boolean simple) throws NoSuchMethodException {
        this.addMethod(methodName, type, new Class[]{String.class, Object[].class}, "*", mode, simple);
    }
}

