/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.accessor;

import hprose.io.HproseMode;
import hprose.io.accessor.BoolFieldAccessor;
import hprose.io.accessor.ByteFieldAccessor;
import hprose.io.accessor.CharFieldAccessor;
import hprose.io.accessor.DoubleFieldAccessor;
import hprose.io.accessor.FieldAccessor;
import hprose.io.accessor.FloatFieldAccessor;
import hprose.io.accessor.IntFieldAccessor;
import hprose.io.accessor.LongFieldAccessor;
import hprose.io.accessor.MemberAccessor;
import hprose.io.accessor.PropertyAccessor;
import hprose.io.accessor.SafeFieldAccessor;
import hprose.io.accessor.ShortFieldAccessor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sun.misc.Unsafe;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Accessors {
    private static final ConcurrentHashMap<Class<?>, HashMap<String, MemberAccessor>> propertiesCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, HashMap<String, MemberAccessor>> membersCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, HashMap<String, MemberAccessor>> fieldsCache = new ConcurrentHashMap();
    static final Unsafe unsafe = Accessors.getUnsafe();

    private static Unsafe getUnsafe() {
        try {
            return Unsafe.getUnsafe();
        }
        catch (Exception e) {
            try {
                Class<Unsafe> k = Unsafe.class;
                for (Field f : k.getDeclaredFields()) {
                    f.setAccessible(true);
                    Object x = f.get(null);
                    if (!k.isInstance(x)) continue;
                    return (Unsafe)k.cast(x);
                }
                return null;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public static final boolean isAndroid() {
        String vmName = System.getProperty("java.vm.name");
        if (vmName == null) {
            return false;
        }
        String lowerVMName = vmName.toLowerCase();
        return lowerVMName.contains("dalvik") || lowerVMName.contains("lemur");
    }

    private static Method findGetter(Method[] methods, String name, Class<?> paramType) {
        String getterName = "get" + name;
        String isGetterName = "is" + name;
        for (Method method : methods) {
            String methodName;
            if (Modifier.isStatic(method.getModifiers()) || !(methodName = method.getName()).equals(getterName) && !methodName.equals(isGetterName) || !method.getReturnType().equals(paramType) || method.getParameterTypes().length != 0) continue;
            return method;
        }
        return null;
    }

    private static Map<String, MemberAccessor> getProperties(Class<?> type) {
        HashMap<String, MemberAccessor> properties = propertiesCache.get(type);
        if (properties == null) {
            Method[] methods;
            properties = new HashMap();
            for (Method setter : methods = type.getMethods()) {
                String propertyName;
                Method getter;
                Class<?>[] paramTypes;
                String name;
                if (Modifier.isStatic(setter.getModifiers()) || !(name = setter.getName()).startsWith("set") || !setter.getReturnType().equals(Void.TYPE) || (paramTypes = setter.getParameterTypes()).length != 1 || (getter = Accessors.findGetter(methods, propertyName = name.substring(3), paramTypes[0])) == null) continue;
                PropertyAccessor propertyAccessor = new PropertyAccessor(getter, setter);
                char[] cname = propertyName.toCharArray();
                cname[0] = Character.toLowerCase(cname[0]);
                propertyName = new String(cname);
                properties.put(propertyName, propertyAccessor);
            }
            propertiesCache.put(type, properties);
        }
        return properties;
    }

    private static MemberAccessor getFieldAccessor(Field field) {
        if (unsafe != null && !Accessors.isAndroid()) {
            Class<?> cls = field.getType();
            if (cls == Integer.TYPE) {
                return new IntFieldAccessor(field);
            }
            if (cls == Byte.TYPE) {
                return new ByteFieldAccessor(field);
            }
            if (cls == Short.TYPE) {
                return new ShortFieldAccessor(field);
            }
            if (cls == Long.TYPE) {
                return new LongFieldAccessor(field);
            }
            if (cls == Boolean.TYPE) {
                return new BoolFieldAccessor(field);
            }
            if (cls == Character.TYPE) {
                return new CharFieldAccessor(field);
            }
            if (cls == Float.TYPE) {
                return new FloatFieldAccessor(field);
            }
            if (cls == Double.TYPE) {
                return new DoubleFieldAccessor(field);
            }
            return new FieldAccessor(field);
        }
        return new SafeFieldAccessor(field);
    }

    private static Map<String, MemberAccessor> getFields(Class<?> type) {
        HashMap<String, MemberAccessor> fields = fieldsCache.get(type);
        if (fields == null) {
            fields = new HashMap();
            for (Class<?> clazz = type; clazz != null; clazz = clazz.getSuperclass()) {
                Field[] fs;
                for (Field field : fs = clazz.getDeclaredFields()) {
                    int mod = field.getModifiers();
                    if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                    String fieldName = field.getName();
                    fields.put(fieldName, Accessors.getFieldAccessor(field));
                }
            }
            fieldsCache.put(type, fields);
        }
        return fields;
    }

    private static Map<String, MemberAccessor> getMembers(Class<?> type) {
        HashMap<String, MemberAccessor> members = membersCache.get(type);
        if (members == null) {
            Field[] fs;
            Method[] methods;
            members = new HashMap();
            for (Method setter : methods = type.getMethods()) {
                String propertyName;
                Method getter;
                Class<?>[] paramTypes;
                String name;
                if (Modifier.isStatic(setter.getModifiers()) || !(name = setter.getName()).startsWith("set") || !setter.getReturnType().equals(Void.TYPE) || (paramTypes = setter.getParameterTypes()).length != 1 || (getter = Accessors.findGetter(methods, propertyName = name.substring(3), paramTypes[0])) == null) continue;
                PropertyAccessor propertyAccessor = new PropertyAccessor(getter, setter);
                char[] cname = propertyName.toCharArray();
                cname[0] = Character.toLowerCase(cname[0]);
                propertyName = new String(cname);
                members.put(propertyName, propertyAccessor);
            }
            for (Field field : fs = type.getFields()) {
                int mod = field.getModifiers();
                if (Modifier.isTransient(mod) || Modifier.isStatic(mod)) continue;
                String fieldName = field.getName();
                members.put(fieldName, Accessors.getFieldAccessor(field));
            }
            membersCache.put(type, members);
        }
        return members;
    }

    public static final Map<String, MemberAccessor> getMembers(Class<?> type, HproseMode mode) {
        return mode != HproseMode.MemberMode && Serializable.class.isAssignableFrom(type) ? (mode == HproseMode.FieldMode ? Accessors.getFields(type) : Accessors.getProperties(type)) : Accessors.getMembers(type);
    }
}

