/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.accessor;

import hprose.common.HproseException;
import hprose.io.accessor.Accessors;
import hprose.io.accessor.MemberAccessor;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.ByteUnserializer;
import hprose.io.unserialize.Reader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;

public final class ByteFieldAccessor
implements MemberAccessor {
    private final long offset;

    public ByteFieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
    }

    public void serialize(Writer writer, Object obj) throws IOException {
        byte value;
        try {
            value = Accessors.unsafe.getByte(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
        ValueWriter.write(writer.stream, value);
    }

    public void unserialize(Reader reader, ByteBuffer buffer, Object obj) throws IOException {
        byte value = ByteUnserializer.read(reader, buffer);
        try {
            Accessors.unsafe.putByte(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }

    public void unserialize(Reader reader, InputStream stream, Object obj) throws IOException {
        byte value = ByteUnserializer.read(reader, stream);
        try {
            Accessors.unsafe.putInt(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }
}

