/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.accessor;

import hprose.common.HproseException;
import hprose.io.accessor.Accessors;
import hprose.io.accessor.MemberAccessor;
import hprose.io.serialize.Serializer;
import hprose.io.serialize.SerializerFactory;
import hprose.io.serialize.Writer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.UnserializerFactory;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

public final class FieldAccessor
implements MemberAccessor {
    private final long offset;
    private final Class<?> cls;
    private final Type type;
    private final Serializer serializer;
    private final Unserializer unserializer;

    public FieldAccessor(Field accessor) {
        accessor.setAccessible(true);
        this.offset = Accessors.unsafe.objectFieldOffset(accessor);
        this.type = accessor.getGenericType();
        this.cls = accessor.getType();
        this.serializer = SerializerFactory.get(this.cls);
        this.unserializer = UnserializerFactory.get(this.cls);
    }

    public void serialize(Writer writer, Object obj) throws IOException {
        Object value;
        try {
            value = Accessors.unsafe.getObject(obj, this.offset);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
        if (value == null) {
            writer.stream.write(110);
        } else {
            this.serializer.write(writer, value);
        }
    }

    public void unserialize(Reader reader, ByteBuffer buffer, Object obj) throws IOException {
        Object value = this.unserializer.read(reader, buffer, this.cls, this.type);
        try {
            Accessors.unsafe.putObject(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }

    public void unserialize(Reader reader, InputStream stream, Object obj) throws IOException {
        Object value = this.unserializer.read(reader, stream, this.cls, this.type);
        try {
            Accessors.unsafe.putObject(obj, this.offset, value);
        }
        catch (Exception e) {
            throw new HproseException(e.getMessage());
        }
    }
}

