/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BigDecimalArraySerializer
implements Serializer<BigDecimal[]> {
    public static final BigDecimalArraySerializer instance = new BigDecimalArraySerializer();

    BigDecimalArraySerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, BigDecimal[] array) throws IOException {
        if (refer != null) {
            refer.set(array);
        }
        int length = array.length;
        stream.write(97);
        if (length > 0) {
            ValueWriter.writeInt(stream, length);
        }
        stream.write(123);
        for (int i = 0; i < length; ++i) {
            BigDecimal e = array[i];
            if (e == null) {
                stream.write(110);
                continue;
            }
            ValueWriter.write(stream, e);
        }
        stream.write(125);
    }

    @Override
    public final void write(Writer writer, BigDecimal[] obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            BigDecimalArraySerializer.write(stream, refer, obj);
        }
    }
}

