/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import hprose.util.TimeZoneUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.TimeZone;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarSerializer
implements Serializer<Calendar> {
    public static final CalendarSerializer instance = new CalendarSerializer();

    CalendarSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, Calendar calendar) throws IOException {
        TimeZone tz;
        if (refer != null) {
            refer.set(calendar);
        }
        if (!(tz = calendar.getTimeZone()).hasSameRules(TimeZoneUtil.DefaultTZ) && !tz.hasSameRules(TimeZoneUtil.UTC)) {
            tz = TimeZoneUtil.UTC;
            Calendar c = (Calendar)calendar.clone();
            c.setTimeZone(tz);
            calendar = c;
        }
        ValueWriter.writeDateOfCalendar(stream, calendar);
        ValueWriter.writeTimeOfCalendar(stream, calendar, true, false);
        stream.write(tz.hasSameRules(TimeZoneUtil.UTC) ? 90 : 59);
    }

    @Override
    public final void write(Writer writer, Calendar obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            CalendarSerializer.write(stream, refer, obj);
        }
    }
}

