/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateTimeSerializer
implements Serializer<Date> {
    public static final DateTimeSerializer instance = new DateTimeSerializer();

    DateTimeSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, Date date) throws IOException {
        if (refer != null) {
            refer.set(date);
        }
        Calendar calendar = DateTime.toCalendar(date);
        ValueWriter.writeDateOfCalendar(stream, calendar);
        ValueWriter.writeTimeOfCalendar(stream, calendar, true, false);
        stream.write(59);
    }

    @Override
    public final void write(Writer writer, Date obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            DateTimeSerializer.write(stream, refer, obj);
        }
    }
}

