/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class HproseDateTimeSerializer
implements Serializer<DateTime> {
    public static final HproseDateTimeSerializer instance = new HproseDateTimeSerializer();

    HproseDateTimeSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, DateTime dt) throws IOException {
        if (refer != null) {
            refer.set(dt);
        }
        if (dt.year == 1970 && dt.month == 1 && dt.day == 1) {
            ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, false, true);
            ValueWriter.writeNano(stream, dt.nanosecond);
        } else {
            ValueWriter.writeDate(stream, dt.year, dt.month, dt.day);
            if (dt.nanosecond == 0) {
                ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, true, true);
            } else {
                ValueWriter.writeTime(stream, dt.hour, dt.minute, dt.second, 0, false, true);
                ValueWriter.writeNano(stream, dt.nanosecond);
            }
        }
        stream.write(dt.utc ? 90 : 59);
    }

    @Override
    public final void write(Writer writer, DateTime obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            HproseDateTimeSerializer.write(stream, refer, obj);
        }
    }
}

