/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalDateSerializer
implements Serializer<LocalDate> {
    public static final LocalDateSerializer instance = new LocalDateSerializer();

    LocalDateSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, LocalDate date) throws IOException {
        int year;
        if (refer != null) {
            refer.set(date);
        }
        if ((year = date.getYear()) > 9999 || year < 1) {
            stream.write(115);
            ValueWriter.write(stream, date.toString());
        } else {
            ValueWriter.writeDate(stream, year, date.getMonthValue(), date.getDayOfMonth());
            stream.write(59);
        }
    }

    @Override
    public final void write(Writer writer, LocalDate obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            LocalDateSerializer.write(stream, refer, obj);
        }
    }
}

