/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;
import java.time.LocalDateTime;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LocalDateTimeSerializer
implements Serializer<LocalDateTime> {
    public static final LocalDateTimeSerializer instance = new LocalDateTimeSerializer();

    LocalDateTimeSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, LocalDateTime datetime) throws IOException {
        int year;
        if (refer != null) {
            refer.set(datetime);
        }
        if ((year = datetime.getYear()) > 9999 || year < 1) {
            stream.write(115);
            ValueWriter.write(stream, datetime.toString());
        } else {
            ValueWriter.writeDate(stream, year, datetime.getMonthValue(), datetime.getDayOfMonth());
            ValueWriter.writeTime(stream, datetime.getHour(), datetime.getMinute(), datetime.getSecond(), 0, false, true);
            ValueWriter.writeNano(stream, datetime.getNano());
            stream.write(59);
        }
    }

    @Override
    public final void write(Writer writer, LocalDateTime obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            LocalDateTimeSerializer.write(stream, refer, obj);
        }
    }
}

