/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class LongArraySerializer
implements Serializer<long[]> {
    public static final LongArraySerializer instance = new LongArraySerializer();

    LongArraySerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, long[] array) throws IOException {
        if (refer != null) {
            refer.set(array);
        }
        int length = array.length;
        stream.write(97);
        if (length > 0) {
            ValueWriter.writeInt(stream, length);
        }
        stream.write(123);
        for (int i = 0; i < length; ++i) {
            ValueWriter.write(stream, array[i]);
        }
        stream.write(125);
    }

    @Override
    public final void write(Writer writer, long[] obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            LongArraySerializer.write(stream, refer, obj);
        }
    }
}

