/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;
import java.time.OffsetTime;
import java.time.ZoneOffset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OffsetTimeSerializer
implements Serializer<OffsetTime> {
    public static final OffsetTimeSerializer instance = new OffsetTimeSerializer();

    OffsetTimeSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, OffsetTime time) throws IOException {
        if (refer != null) {
            refer.set(time);
        }
        if (!time.getOffset().equals(ZoneOffset.UTC)) {
            stream.write(115);
            ValueWriter.write(stream, time.toString());
        } else {
            ValueWriter.writeTime(stream, time.getHour(), time.getMinute(), time.getSecond(), 0, false, true);
            ValueWriter.writeNano(stream, time.getNano());
            stream.write(90);
        }
    }

    @Override
    public final void write(Writer writer, OffsetTime obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            OffsetTimeSerializer.write(stream, refer, obj);
        }
    }
}

