/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.HproseMode;
import hprose.io.accessor.Accessors;
import hprose.io.accessor.MemberAccessor;
import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import hprose.util.ClassUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.EnumMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class OtherTypeSerializer
implements Serializer {
    public static final OtherTypeSerializer instance = new OtherTypeSerializer();
    private static final EnumMap<HproseMode, ConcurrentHashMap<Class<?>, SerializeCache>> memberCache = new EnumMap(HproseMode.class);

    OtherTypeSerializer() {
    }

    private static void writeObject(Writer writer, Object object, Class<?> type) throws IOException {
        Map<String, MemberAccessor> members = Accessors.getMembers(type, writer.mode);
        for (Map.Entry<String, MemberAccessor> entry : members.entrySet()) {
            MemberAccessor member = entry.getValue();
            member.serialize(writer, object);
        }
    }

    private static int writeClass(Writer writer, Class<?> type) throws IOException {
        SerializeCache cache = memberCache.get((Object)writer.mode).get(type);
        if (cache == null) {
            cache = new SerializeCache();
            ByteArrayOutputStream cachestream = new ByteArrayOutputStream();
            Map<String, MemberAccessor> members = Accessors.getMembers(type, writer.mode);
            int count = members.size();
            cachestream.write(99);
            ValueWriter.write((OutputStream)cachestream, ClassUtil.getClassAlias(type));
            if (count > 0) {
                ValueWriter.writeInt((OutputStream)cachestream, count);
            }
            cachestream.write(123);
            for (Map.Entry<String, MemberAccessor> member : members.entrySet()) {
                cachestream.write(115);
                ValueWriter.write((OutputStream)cachestream, member.getKey());
                ++cache.refcount;
            }
            cachestream.write(125);
            cache.data = cachestream.toByteArray();
            memberCache.get((Object)writer.mode).put(type, cache);
        }
        writer.stream.write(cache.data);
        if (writer.refer != null) {
            writer.refer.addCount(cache.refcount);
        }
        int cr = writer.lastclassref++;
        writer.classref.put(type, cr);
        return cr;
    }

    public static final void write(Writer writer, OutputStream stream, WriterRefer refer, Object object) throws IOException {
        Class<?> type = object.getClass();
        Integer cr = writer.classref.get(type);
        if (cr == null) {
            cr = OtherTypeSerializer.writeClass(writer, type);
        }
        if (refer != null) {
            refer.set(object);
        }
        stream.write(111);
        ValueWriter.write(stream, cr);
        stream.write(123);
        OtherTypeSerializer.writeObject(writer, object, type);
        stream.write(125);
    }

    public final void write(Writer writer, Object obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            OtherTypeSerializer.write(writer, stream, refer, obj);
        }
    }

    static {
        memberCache.put(HproseMode.FieldMode, new ConcurrentHashMap());
        memberCache.put(HproseMode.PropertyMode, new ConcurrentHashMap());
        memberCache.put(HproseMode.MemberMode, new ConcurrentHashMap());
    }

    static final class SerializeCache {
        byte[] data;
        int refcount;

        SerializeCache() {
        }
    }
}

