/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.AtomicBooleanSerializer;
import hprose.io.serialize.AtomicIntegerArraySerializer;
import hprose.io.serialize.AtomicIntegerSerializer;
import hprose.io.serialize.AtomicLongArraySerializer;
import hprose.io.serialize.AtomicLongSerializer;
import hprose.io.serialize.AtomicReferenceArraySerializer;
import hprose.io.serialize.AtomicReferenceSerializer;
import hprose.io.serialize.BigDecimalArraySerializer;
import hprose.io.serialize.BigDecimalSerializer;
import hprose.io.serialize.BigIntegerArraySerializer;
import hprose.io.serialize.BigIntegerSerializer;
import hprose.io.serialize.BooleanArraySerializer;
import hprose.io.serialize.BooleanSerializer;
import hprose.io.serialize.ByteArraySerializer;
import hprose.io.serialize.ByteSerializer;
import hprose.io.serialize.BytesArraySerializer;
import hprose.io.serialize.CalendarArraySerializer;
import hprose.io.serialize.CalendarSerializer;
import hprose.io.serialize.CharArraySerializer;
import hprose.io.serialize.CharSerializer;
import hprose.io.serialize.CharsArraySerializer;
import hprose.io.serialize.CollectionSerializer;
import hprose.io.serialize.DateArraySerializer;
import hprose.io.serialize.DateSerializer;
import hprose.io.serialize.DateTimeArraySerializer;
import hprose.io.serialize.DateTimeSerializer;
import hprose.io.serialize.DoubleArraySerializer;
import hprose.io.serialize.DoubleSerializer;
import hprose.io.serialize.EnumSerializer;
import hprose.io.serialize.FloatArraySerializer;
import hprose.io.serialize.FloatSerializer;
import hprose.io.serialize.HproseDateTimeSerializer;
import hprose.io.serialize.IntArraySerializer;
import hprose.io.serialize.IntegerSerializer;
import hprose.io.serialize.ListSerializer;
import hprose.io.serialize.LocalDateSerializer;
import hprose.io.serialize.LocalDateTimeSerializer;
import hprose.io.serialize.LocalTimeSerializer;
import hprose.io.serialize.LongArraySerializer;
import hprose.io.serialize.LongSerializer;
import hprose.io.serialize.MapSerializer;
import hprose.io.serialize.NullSerializer;
import hprose.io.serialize.ObjectSerializer;
import hprose.io.serialize.OffsetDateTimeSerializer;
import hprose.io.serialize.OffsetTimeSerializer;
import hprose.io.serialize.OtherTypeArraySerializer;
import hprose.io.serialize.OtherTypeSerializer;
import hprose.io.serialize.Serializer;
import hprose.io.serialize.ShortArraySerializer;
import hprose.io.serialize.ShortSerializer;
import hprose.io.serialize.StringArraySerializer;
import hprose.io.serialize.StringBufferArraySerializer;
import hprose.io.serialize.StringBufferSerializer;
import hprose.io.serialize.StringBuilderArraySerializer;
import hprose.io.serialize.StringBuilderSerializer;
import hprose.io.serialize.StringSerializer;
import hprose.io.serialize.TimeArraySerializer;
import hprose.io.serialize.TimeSerializer;
import hprose.io.serialize.TimeZoneSerializer;
import hprose.io.serialize.TimestampArraySerializer;
import hprose.io.serialize.TimestampSerializer;
import hprose.io.serialize.ToStringSerializer;
import hprose.io.serialize.UUIDArraySerializer;
import hprose.io.serialize.UUIDSerializer;
import hprose.io.serialize.ZonedDateTimeSerializer;
import hprose.util.DateTime;
import hprose.util.JdkVersion;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializerFactory {
    private static final ConcurrentHashMap<Class<?>, Serializer> serializers = new ConcurrentHashMap();

    public static final Serializer get(Class<?> type) {
        Serializer<Object> serializer = serializers.get(type);
        if (serializer == null) {
            serializer = type.isEnum() ? EnumSerializer.instance : (type.isArray() ? OtherTypeArraySerializer.instance : (Map.class.isAssignableFrom(type) ? MapSerializer.instance : (List.class.isAssignableFrom(type) ? ListSerializer.instance : (Collection.class.isAssignableFrom(type) ? CollectionSerializer.instance : (TimeZone.class.isAssignableFrom(type) ? TimeZoneSerializer.instance : (Calendar.class.isAssignableFrom(type) ? CalendarSerializer.instance : OtherTypeSerializer.instance))))));
            serializers.put(type, serializer);
        }
        return serializer;
    }

    public static final void register(Class<?> type, Serializer serializer) {
        serializers.put(type, serializer);
    }

    static {
        serializers.put(Void.TYPE, NullSerializer.instance);
        serializers.put(Boolean.TYPE, BooleanSerializer.instance);
        serializers.put(Character.TYPE, CharSerializer.instance);
        serializers.put(Byte.TYPE, ByteSerializer.instance);
        serializers.put(Short.TYPE, ShortSerializer.instance);
        serializers.put(Integer.TYPE, IntegerSerializer.instance);
        serializers.put(Long.TYPE, LongSerializer.instance);
        serializers.put(Float.TYPE, FloatSerializer.instance);
        serializers.put(Double.TYPE, DoubleSerializer.instance);
        serializers.put(Object.class, ObjectSerializer.instance);
        serializers.put(Void.class, NullSerializer.instance);
        serializers.put(Boolean.class, BooleanSerializer.instance);
        serializers.put(Character.class, CharSerializer.instance);
        serializers.put(Byte.class, ByteSerializer.instance);
        serializers.put(Short.class, ShortSerializer.instance);
        serializers.put(Integer.class, IntegerSerializer.instance);
        serializers.put(Long.class, LongSerializer.instance);
        serializers.put(Float.class, FloatSerializer.instance);
        serializers.put(Double.class, DoubleSerializer.instance);
        serializers.put(String.class, StringSerializer.instance);
        serializers.put(BigInteger.class, BigIntegerSerializer.instance);
        serializers.put(java.sql.Date.class, DateSerializer.instance);
        serializers.put(Time.class, TimeSerializer.instance);
        serializers.put(Timestamp.class, TimestampSerializer.instance);
        serializers.put(Date.class, DateTimeSerializer.instance);
        serializers.put(Calendar.class, CalendarSerializer.instance);
        serializers.put(BigDecimal.class, BigDecimalSerializer.instance);
        serializers.put(StringBuilder.class, StringBuilderSerializer.instance);
        serializers.put(StringBuffer.class, StringBufferSerializer.instance);
        serializers.put(UUID.class, UUIDSerializer.instance);
        serializers.put(boolean[].class, BooleanArraySerializer.instance);
        serializers.put(char[].class, CharArraySerializer.instance);
        serializers.put(byte[].class, ByteArraySerializer.instance);
        serializers.put(short[].class, ShortArraySerializer.instance);
        serializers.put(int[].class, IntArraySerializer.instance);
        serializers.put(long[].class, LongArraySerializer.instance);
        serializers.put(float[].class, FloatArraySerializer.instance);
        serializers.put(double[].class, DoubleArraySerializer.instance);
        serializers.put(String[].class, StringArraySerializer.instance);
        serializers.put(BigInteger[].class, BigIntegerArraySerializer.instance);
        serializers.put(java.sql.Date[].class, DateArraySerializer.instance);
        serializers.put(Time[].class, TimeArraySerializer.instance);
        serializers.put(Timestamp[].class, TimestampArraySerializer.instance);
        serializers.put(Date[].class, DateTimeArraySerializer.instance);
        serializers.put(Calendar[].class, CalendarArraySerializer.instance);
        serializers.put(BigDecimal[].class, BigDecimalArraySerializer.instance);
        serializers.put(StringBuilder[].class, StringBuilderArraySerializer.instance);
        serializers.put(StringBuffer[].class, StringBufferArraySerializer.instance);
        serializers.put(UUID[].class, UUIDArraySerializer.instance);
        serializers.put(char[][].class, CharsArraySerializer.instance);
        serializers.put(byte[][].class, BytesArraySerializer.instance);
        serializers.put(ArrayList.class, ListSerializer.instance);
        serializers.put(AbstractList.class, ListSerializer.instance);
        serializers.put(AbstractCollection.class, CollectionSerializer.instance);
        serializers.put(List.class, ListSerializer.instance);
        serializers.put(Collection.class, CollectionSerializer.instance);
        serializers.put(LinkedList.class, ListSerializer.instance);
        serializers.put(AbstractSequentialList.class, ListSerializer.instance);
        serializers.put(HashSet.class, CollectionSerializer.instance);
        serializers.put(AbstractSet.class, CollectionSerializer.instance);
        serializers.put(Set.class, CollectionSerializer.instance);
        serializers.put(TreeSet.class, CollectionSerializer.instance);
        serializers.put(SortedSet.class, CollectionSerializer.instance);
        serializers.put(HashMap.class, MapSerializer.instance);
        serializers.put(AbstractMap.class, MapSerializer.instance);
        serializers.put(Map.class, MapSerializer.instance);
        serializers.put(TreeMap.class, MapSerializer.instance);
        serializers.put(SortedMap.class, MapSerializer.instance);
        serializers.put(AtomicBoolean.class, AtomicBooleanSerializer.instance);
        serializers.put(AtomicInteger.class, AtomicIntegerSerializer.instance);
        serializers.put(AtomicLong.class, AtomicLongSerializer.instance);
        serializers.put(AtomicReference.class, AtomicReferenceSerializer.instance);
        serializers.put(AtomicIntegerArray.class, AtomicIntegerArraySerializer.instance);
        serializers.put(AtomicLongArray.class, AtomicLongArraySerializer.instance);
        serializers.put(AtomicReferenceArray.class, AtomicReferenceArraySerializer.instance);
        serializers.put(Locale.class, ToStringSerializer.instance);
        serializers.put(URI.class, ToStringSerializer.instance);
        serializers.put(URL.class, ToStringSerializer.instance);
        serializers.put(Pattern.class, ToStringSerializer.instance);
        serializers.put(TimeZone.class, TimeZoneSerializer.instance);
        serializers.put(DateTime.class, HproseDateTimeSerializer.instance);
        if (JdkVersion.majorJavaVersion >= 8) {
            try {
                serializers.put(Class.forName("java.time.LocalDate"), LocalDateSerializer.instance);
                serializers.put(Class.forName("java.time.LocalTime"), LocalTimeSerializer.instance);
                serializers.put(Class.forName("java.time.LocalDateTime"), LocalDateTimeSerializer.instance);
                serializers.put(Class.forName("java.time.OffsetTime"), OffsetTimeSerializer.instance);
                serializers.put(Class.forName("java.time.OffsetDateTime"), OffsetDateTimeSerializer.instance);
                serializers.put(Class.forName("java.time.ZonedDateTime"), ZonedDateTimeSerializer.instance);
                serializers.put(Class.forName("java.time.Duration"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.Instant"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.MonthDay"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.Period"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.Year"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.YearMonth"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.ZoneId"), ToStringSerializer.instance);
                serializers.put(Class.forName("java.time.ZoneOffset"), ToStringSerializer.instance);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

