/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.serialize.Serializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.Writer;
import hprose.io.serialize.WriterRefer;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Timestamp;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class TimestampSerializer
implements Serializer<Timestamp> {
    public static final TimestampSerializer instance = new TimestampSerializer();

    TimestampSerializer() {
    }

    public static final void write(OutputStream stream, WriterRefer refer, Timestamp time) throws IOException {
        if (refer != null) {
            refer.set(time);
        }
        Calendar calendar = DateTime.toCalendar(time);
        ValueWriter.writeDateOfCalendar(stream, calendar);
        ValueWriter.writeTimeOfCalendar(stream, calendar, false, true);
        ValueWriter.writeNano(stream, time.getNanos());
        stream.write(59);
    }

    @Override
    public final void write(Writer writer, Timestamp obj) throws IOException {
        OutputStream stream = writer.stream;
        WriterRefer refer = writer.refer;
        if (refer == null || !refer.write(stream, obj)) {
            TimestampSerializer.write(stream, refer, obj);
        }
    }
}

