/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Calendar;

public final class ValueWriter {
    private static final byte[] digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] DigitTens = new byte[]{48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 51, 51, 51, 51, 51, 51, 51, 51, 51, 51, 52, 52, 52, 52, 52, 52, 52, 52, 52, 52, 53, 53, 53, 53, 53, 53, 53, 53, 53, 53, 54, 54, 54, 54, 54, 54, 54, 54, 54, 54, 55, 55, 55, 55, 55, 55, 55, 55, 55, 55, 56, 56, 56, 56, 56, 56, 56, 56, 56, 56, 57, 57, 57, 57, 57, 57, 57, 57, 57, 57};
    private static final byte[] DigitOnes = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    private static final byte[] minIntBuf = new byte[]{45, 50, 49, 52, 55, 52, 56, 51, 54, 52, 56};
    private static final byte[] minLongBuf = new byte[]{45, 57, 50, 50, 51, 51, 55, 50, 48, 51, 54, 56, 53, 52, 55, 55, 53, 56, 48, 56};
    private static final ThreadLocal<byte[]> buffer = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[20];
        }
    };

    public static final void writeInt(OutputStream stream, int i) throws IOException {
        if (i >= 0 && i <= 9) {
            stream.write((byte)(48 + i));
        } else if (i == Integer.MIN_VALUE) {
            stream.write(minIntBuf);
        } else {
            int r;
            int q;
            byte[] buf = buffer.get();
            int off = 20;
            int sign = 0;
            if (i < 0) {
                sign = 45;
                i = -i;
            }
            while (i >= 65536) {
                q = i / 100;
                r = i - q * 100;
                i = q;
                buf[--off] = DigitOnes[r];
                buf[--off] = DigitTens[r];
            }
            do {
                q = i * 52429 >>> 19;
                r = i - q * 10;
                buf[--off] = digits[r];
            } while ((i = q) != 0);
            if (sign != 0) {
                buf[--off] = sign;
            }
            stream.write(buf, off, 20 - off);
        }
    }

    public static final void writeInt(OutputStream stream, long i) throws IOException {
        if (i >= 0L && i <= 9L) {
            stream.write((byte)(48L + i));
        } else if (i == Long.MIN_VALUE) {
            stream.write(minLongBuf);
        } else {
            int q2;
            int r;
            byte[] buf = buffer.get();
            int off = 20;
            int sign = 0;
            if (i < 0L) {
                sign = 45;
                i = -i;
            }
            while (i >= 65536L) {
                long q = i / 100L;
                r = (int)(i - q * 100L);
                i = q;
                buf[--off] = DigitOnes[r];
                buf[--off] = DigitTens[r];
            }
            int i2 = (int)i;
            while (i2 >= 65536) {
                q2 = i2 / 100;
                r = i2 - q2 * 100;
                i2 = q2;
                buf[--off] = DigitOnes[r];
                buf[--off] = DigitTens[r];
            }
            do {
                q2 = i2 * 52429 >>> 19;
                r = i2 - q2 * 10;
                buf[--off] = digits[r];
            } while ((i2 = q2) != 0);
            if (sign != 0) {
                buf[--off] = sign;
            }
            stream.write(buf, off, 20 - off);
        }
    }

    public static final void write(OutputStream stream, int i) throws IOException {
        if (i >= 0 && i <= 9) {
            stream.write(i + 48);
        } else {
            stream.write(105);
            ValueWriter.writeInt(stream, i);
            stream.write(59);
        }
    }

    public static final void write(OutputStream stream, long l) throws IOException {
        if (l >= 0L && l <= 9L) {
            stream.write((int)l + 48);
        } else {
            stream.write(108);
            ValueWriter.writeInt(stream, l);
            stream.write(59);
        }
    }

    public static final void write(OutputStream stream, boolean b) throws IOException {
        stream.write(b ? 116 : 102);
    }

    public static final void write(OutputStream stream, float f) throws IOException {
        if (Float.isNaN(f)) {
            stream.write(78);
        } else if (Float.isInfinite(f)) {
            stream.write(73);
            stream.write(f > 0.0f ? 43 : 45);
        } else {
            stream.write(100);
            stream.write(ValueWriter.getAscii(Float.toString(f)));
            stream.write(59);
        }
    }

    public static final void write(OutputStream stream, double d) throws IOException {
        if (Double.isNaN(d)) {
            stream.write(78);
        } else if (Double.isInfinite(d)) {
            stream.write(73);
            stream.write(d > 0.0 ? 43 : 45);
        } else {
            stream.write(100);
            stream.write(ValueWriter.getAscii(Double.toString(d)));
            stream.write(59);
        }
    }

    public static final void write(OutputStream stream, BigInteger bi) throws IOException {
        stream.write(108);
        stream.write(ValueWriter.getAscii(bi.toString()));
        stream.write(59);
    }

    public static final void write(OutputStream stream, BigDecimal bd) throws IOException {
        stream.write(100);
        stream.write(ValueWriter.getAscii(bd.toString()));
        stream.write(59);
    }

    public static final void write(OutputStream stream, char c) throws IOException {
        stream.write(117);
        if (c < '\u0080') {
            stream.write(c);
        } else if (c < '\u0800') {
            stream.write(0xC0 | c >>> 6);
            stream.write(0x80 | c & 0x3F);
        } else {
            stream.write(0xE0 | c >>> 12);
            stream.write(0x80 | c >>> 6 & 0x3F);
            stream.write(0x80 | c & 0x3F);
        }
    }

    static final void write(OutputStream stream, char[] s) throws IOException {
        int length = s.length;
        if (length > 0) {
            ValueWriter.writeInt(stream, length);
        }
        stream.write(34);
        stream.write(new String(s).getBytes("UTF-8"));
        stream.write(34);
    }

    static final void write(OutputStream stream, String s) throws IOException {
        int length = s.length();
        if (length > 0) {
            ValueWriter.writeInt(stream, length);
        }
        stream.write(34);
        stream.write(s.getBytes("UTF-8"));
        stream.write(34);
    }

    static final void writeDate(OutputStream stream, int year, int month, int day) throws IOException {
        stream.write(68);
        stream.write((byte)(48 + year / 1000 % 10));
        stream.write((byte)(48 + year / 100 % 10));
        stream.write((byte)(48 + year / 10 % 10));
        stream.write((byte)(48 + year % 10));
        stream.write((byte)(48 + month / 10 % 10));
        stream.write((byte)(48 + month % 10));
        stream.write((byte)(48 + day / 10 % 10));
        stream.write((byte)(48 + day % 10));
    }

    static final void writeDateOfCalendar(OutputStream stream, Calendar calendar) throws IOException {
        ValueWriter.writeDate(stream, calendar.get(1), calendar.get(2) + 1, calendar.get(5));
    }

    static final void writeTime(OutputStream stream, int hour, int minute, int second, int millisecond, boolean ignoreZero, boolean ignoreMillisecond) throws IOException {
        if (ignoreZero && hour == 0 && minute == 0 && second == 0 && millisecond == 0) {
            return;
        }
        stream.write(84);
        stream.write((byte)(48 + hour / 10 % 10));
        stream.write((byte)(48 + hour % 10));
        stream.write((byte)(48 + minute / 10 % 10));
        stream.write((byte)(48 + minute % 10));
        stream.write((byte)(48 + second / 10 % 10));
        stream.write((byte)(48 + second % 10));
        if (!ignoreMillisecond && millisecond > 0) {
            stream.write(46);
            stream.write((byte)(48 + millisecond / 100 % 10));
            stream.write((byte)(48 + millisecond / 10 % 10));
            stream.write((byte)(48 + millisecond % 10));
        }
    }

    static final void writeTimeOfCalendar(OutputStream stream, Calendar calendar, boolean ignoreZero, boolean ignoreMillisecond) throws IOException {
        ValueWriter.writeTime(stream, calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), ignoreZero, ignoreMillisecond);
    }

    static final void writeNano(OutputStream stream, int nanosecond) throws IOException {
        if (nanosecond > 0) {
            stream.write(46);
            stream.write((byte)(48 + nanosecond / 100000000 % 10));
            stream.write((byte)(48 + nanosecond / 10000000 % 10));
            stream.write((byte)(48 + nanosecond / 1000000 % 10));
            if (nanosecond % 1000000 > 0) {
                stream.write((byte)(48 + nanosecond / 100000 % 10));
                stream.write((byte)(48 + nanosecond / 10000 % 10));
                stream.write((byte)(48 + nanosecond / 1000 % 10));
                if (nanosecond % 1000 > 0) {
                    stream.write((byte)(48 + nanosecond / 100 % 10));
                    stream.write((byte)(48 + nanosecond / 10 % 10));
                    stream.write((byte)(48 + nanosecond % 10));
                }
            }
        }
    }

    static final byte[] getAscii(String s) {
        int size = s.length();
        byte[] b = new byte[size--];
        while (size >= 0) {
            b[size] = (byte)s.charAt(size);
            --size;
        }
        return b;
    }
}

