/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.serialize;

import hprose.io.HproseMode;
import hprose.io.serialize.AtomicIntegerArraySerializer;
import hprose.io.serialize.AtomicLongArraySerializer;
import hprose.io.serialize.AtomicReferenceArraySerializer;
import hprose.io.serialize.BigDecimalArraySerializer;
import hprose.io.serialize.BigIntegerArraySerializer;
import hprose.io.serialize.BooleanArraySerializer;
import hprose.io.serialize.ByteArraySerializer;
import hprose.io.serialize.BytesArraySerializer;
import hprose.io.serialize.CalendarArraySerializer;
import hprose.io.serialize.CalendarSerializer;
import hprose.io.serialize.CharArraySerializer;
import hprose.io.serialize.CharsArraySerializer;
import hprose.io.serialize.CollectionSerializer;
import hprose.io.serialize.DateArraySerializer;
import hprose.io.serialize.DateSerializer;
import hprose.io.serialize.DateTimeArraySerializer;
import hprose.io.serialize.DateTimeSerializer;
import hprose.io.serialize.DoubleArraySerializer;
import hprose.io.serialize.FloatArraySerializer;
import hprose.io.serialize.IntArraySerializer;
import hprose.io.serialize.ListSerializer;
import hprose.io.serialize.LongArraySerializer;
import hprose.io.serialize.MapSerializer;
import hprose.io.serialize.ObjectArraySerializer;
import hprose.io.serialize.OtherTypeArraySerializer;
import hprose.io.serialize.OtherTypeSerializer;
import hprose.io.serialize.SerializerFactory;
import hprose.io.serialize.ShortArraySerializer;
import hprose.io.serialize.StringArraySerializer;
import hprose.io.serialize.StringBufferArraySerializer;
import hprose.io.serialize.StringBufferSerializer;
import hprose.io.serialize.StringBuilderArraySerializer;
import hprose.io.serialize.StringBuilderSerializer;
import hprose.io.serialize.StringSerializer;
import hprose.io.serialize.TimeArraySerializer;
import hprose.io.serialize.TimeSerializer;
import hprose.io.serialize.TimestampArraySerializer;
import hprose.io.serialize.TimestampSerializer;
import hprose.io.serialize.UUIDArraySerializer;
import hprose.io.serialize.UUIDSerializer;
import hprose.io.serialize.ValueWriter;
import hprose.io.serialize.WriterRefer;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Writer {
    public final OutputStream stream;
    final WriterRefer refer;
    final HproseMode mode;
    final HashMap<Class<?>, Integer> classref = new HashMap();
    int lastclassref = 0;

    public Writer(OutputStream stream) {
        this(stream, HproseMode.MemberMode, false);
    }

    public Writer(OutputStream stream, boolean simple) {
        this(stream, HproseMode.MemberMode, simple);
    }

    public Writer(OutputStream stream, HproseMode mode) {
        this(stream, mode, false);
    }

    public Writer(OutputStream stream, HproseMode mode, boolean simple) {
        this.stream = stream;
        this.mode = mode;
        this.refer = simple ? null : new WriterRefer();
    }

    public final void serialize(Object obj) throws IOException {
        if (obj == null) {
            this.stream.write(110);
        } else {
            SerializerFactory.get(obj.getClass()).write(this, obj);
        }
    }

    public final void writeInteger(int i) throws IOException {
        ValueWriter.write(this.stream, i);
    }

    public final void writeLong(long l) throws IOException {
        ValueWriter.write(this.stream, l);
    }

    public final void writeBigInteger(BigInteger bi) throws IOException {
        ValueWriter.write(this.stream, bi);
    }

    public final void writeFloat(float f) throws IOException {
        ValueWriter.write(this.stream, f);
    }

    public final void writeDouble(double d) throws IOException {
        ValueWriter.write(this.stream, d);
    }

    public final void writeBigDecimal(BigDecimal bd) throws IOException {
        ValueWriter.write(this.stream, bd);
    }

    public final void writeNaN() throws IOException {
        this.stream.write(78);
    }

    public final void writeInfinity(boolean positive) throws IOException {
        this.stream.write(73);
        this.stream.write(positive ? 43 : 45);
    }

    public final void writeNull() throws IOException {
        this.stream.write(110);
    }

    public final void writeEmpty() throws IOException {
        this.stream.write(101);
    }

    public final void writeBoolean(boolean b) throws IOException {
        this.stream.write(b ? 116 : 102);
    }

    public final void writeDate(Date date) throws IOException {
        DateSerializer.write(this.stream, this.refer, date);
    }

    public final void writeDateWithRef(Date date) throws IOException {
        DateSerializer.instance.write(this, date);
    }

    public final void writeDate(Time time) throws IOException {
        TimeSerializer.write(this.stream, this.refer, time);
    }

    public final void writeDateWithRef(Time time) throws IOException {
        TimeSerializer.instance.write(this, time);
    }

    public final void writeDate(Timestamp time) throws IOException {
        TimestampSerializer.write(this.stream, this.refer, time);
    }

    public final void writeDateWithRef(Timestamp time) throws IOException {
        TimestampSerializer.instance.write(this, time);
    }

    public final void writeDate(java.util.Date date) throws IOException {
        DateTimeSerializer.write(this.stream, this.refer, date);
    }

    public final void writeDateWithRef(java.util.Date date) throws IOException {
        DateTimeSerializer.instance.write(this, date);
    }

    public final void writeDate(Calendar calendar) throws IOException {
        CalendarSerializer.write(this.stream, this.refer, calendar);
    }

    public final void writeDateWithRef(Calendar calendar) throws IOException {
        CalendarSerializer.instance.write(this, calendar);
    }

    public final void writeTime(Time time) throws IOException {
        this.writeDate(time);
    }

    public final void writeTimeWithRef(Time time) throws IOException {
        this.writeDateWithRef(time);
    }

    public final void writeBytes(byte[] bytes) throws IOException {
        ByteArraySerializer.write(this.stream, this.refer, bytes);
    }

    public final void writeBytesWithRef(byte[] bytes) throws IOException {
        ByteArraySerializer.instance.write(this, bytes);
    }

    public final void writeUTF8Char(char c) throws IOException {
        ValueWriter.write(this.stream, c);
    }

    public final void writeString(String s) throws IOException {
        StringSerializer.write(this.stream, this.refer, s);
    }

    public final void writeStringWithRef(String s) throws IOException {
        StringSerializer.instance.write(this, s);
    }

    public final void writeString(StringBuilder s) throws IOException {
        StringBuilderSerializer.write(this.stream, this.refer, s);
    }

    public final void writeStringWithRef(StringBuilder s) throws IOException {
        StringBuilderSerializer.instance.write(this, s);
    }

    public final void writeString(StringBuffer s) throws IOException {
        StringBufferSerializer.write(this.stream, this.refer, s);
    }

    public final void writeStringWithRef(StringBuffer s) throws IOException {
        StringBufferSerializer.instance.write(this, s);
    }

    public final void writeString(char[] s) throws IOException {
        CharArraySerializer.write(this.stream, this.refer, s);
    }

    public final void writeStringWithRef(char[] s) throws IOException {
        CharArraySerializer.instance.write(this, s);
    }

    public final void writeUUID(UUID uuid) throws IOException {
        UUIDSerializer.write(this.stream, this.refer, uuid);
    }

    public final void writeUUIDWithRef(UUID uuid) throws IOException {
        UUIDSerializer.instance.write(this, uuid);
    }

    public final void writeArray(short[] array) throws IOException {
        ShortArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(short[] array) throws IOException {
        ShortArraySerializer.instance.write(this, array);
    }

    public final void writeArray(int[] array) throws IOException {
        IntArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(int[] array) throws IOException {
        IntArraySerializer.instance.write(this, array);
    }

    public final void writeArray(long[] array) throws IOException {
        LongArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(long[] array) throws IOException {
        LongArraySerializer.instance.write(this, array);
    }

    public final void writeArray(float[] array) throws IOException {
        FloatArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(float[] array) throws IOException {
        FloatArraySerializer.instance.write(this, array);
    }

    public final void writeArray(double[] array) throws IOException {
        DoubleArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(double[] array) throws IOException {
        DoubleArraySerializer.instance.write(this, array);
    }

    public final void writeArray(boolean[] array) throws IOException {
        BooleanArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(boolean[] array) throws IOException {
        BooleanArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Date[] array) throws IOException {
        DateArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Date[] array) throws IOException {
        DateArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Time[] array) throws IOException {
        TimeArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Time[] array) throws IOException {
        TimeArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Timestamp[] array) throws IOException {
        TimestampArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Timestamp[] array) throws IOException {
        TimestampArraySerializer.instance.write(this, array);
    }

    public final void writeArray(java.util.Date[] array) throws IOException {
        DateTimeArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(java.util.Date[] array) throws IOException {
        DateTimeArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Calendar[] array) throws IOException {
        CalendarArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Calendar[] array) throws IOException {
        CalendarArraySerializer.instance.write(this, array);
    }

    public final void writeArray(String[] array) throws IOException {
        StringArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(String[] array) throws IOException {
        StringArraySerializer.instance.write(this, array);
    }

    public final void writeArray(StringBuilder[] array) throws IOException {
        StringBuilderArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(StringBuilder[] array) throws IOException {
        StringBuilderArraySerializer.instance.write(this, array);
    }

    public final void writeArray(StringBuffer[] array) throws IOException {
        StringBufferArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(StringBuffer[] array) throws IOException {
        StringBufferArraySerializer.instance.write(this, array);
    }

    public final void writeArray(UUID[] array) throws IOException {
        UUIDArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(UUID[] array) throws IOException {
        UUIDArraySerializer.instance.write(this, array);
    }

    public final void writeArray(char[][] array) throws IOException {
        CharsArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(char[][] array) throws IOException {
        CharsArraySerializer.instance.write(this, array);
    }

    public final void writeArray(byte[][] array) throws IOException {
        BytesArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(byte[][] array) throws IOException {
        BytesArraySerializer.instance.write(this, array);
    }

    public final void writeArray(BigInteger[] array) throws IOException {
        BigIntegerArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(BigInteger[] array) throws IOException {
        BigIntegerArraySerializer.instance.write(this, array);
    }

    public final void writeArray(BigDecimal[] array) throws IOException {
        BigDecimalArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(BigDecimal[] array) throws IOException {
        BigDecimalArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Object[] array) throws IOException {
        ObjectArraySerializer.write(this, this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Object[] array) throws IOException {
        ObjectArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicIntegerArray array) throws IOException {
        AtomicIntegerArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(AtomicIntegerArray array) throws IOException {
        AtomicIntegerArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicLongArray array) throws IOException {
        AtomicLongArraySerializer.write(this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(AtomicLongArray array) throws IOException {
        AtomicLongArraySerializer.instance.write(this, array);
    }

    public final void writeArray(AtomicReferenceArray array) throws IOException {
        AtomicReferenceArraySerializer.write(this, this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(AtomicReferenceArray array) throws IOException {
        AtomicReferenceArraySerializer.instance.write(this, array);
    }

    public final void writeArray(Object array) throws IOException {
        OtherTypeArraySerializer.write(this, this.stream, this.refer, array);
    }

    public final void writeArrayWithRef(Object array) throws IOException {
        OtherTypeArraySerializer.instance.write(this, array);
    }

    public final void writeCollection(Collection<?> collection) throws IOException {
        CollectionSerializer.write(this, this.stream, this.refer, collection);
    }

    public final void writeCollectionWithRef(Collection<?> collection) throws IOException {
        CollectionSerializer.instance.write(this, collection);
    }

    public final void writeList(List<?> list) throws IOException {
        ListSerializer.write(this, this.stream, this.refer, list);
    }

    public final void writeListWithRef(List<?> list) throws IOException {
        ListSerializer.instance.write(this, list);
    }

    public final void writeMap(Map<?, ?> map) throws IOException {
        MapSerializer.write(this, this.stream, this.refer, map);
    }

    public final void writeMapWithRef(Map<?, ?> map) throws IOException {
        MapSerializer.instance.write(this, map);
    }

    public final void writeObject(Object object) throws IOException {
        OtherTypeSerializer.write(this, this.stream, this.refer, object);
    }

    public final void writeObjectWithRef(Object object) throws IOException {
        OtherTypeSerializer.instance.write(this, object);
    }

    public final void reset() {
        if (this.refer != null) {
            this.refer.reset();
        }
        this.classref.clear();
        this.lastclassref = 0;
    }
}

