/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.UnserializerFactory;
import hprose.io.unserialize.ValueReader;
import hprose.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayListUnserializer
implements Unserializer {
    public static final ArrayListUnserializer instance = new ArrayListUnserializer();

    ArrayListUnserializer() {
    }

    private static <T> ArrayList<T> readArrayList(Reader reader, ByteBuffer buffer, Class<?> cls, Class<T> componentClass, Type componentType) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                ArrayList<Object> a = new ArrayList<Object>(count);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a.add(unserializer.read(reader, buffer, componentClass, componentType));
                }
                buffer.get();
                return a;
            }
            case 114: {
                return (ArrayList)reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    private static <T> ArrayList<T> readArrayList(Reader reader, InputStream stream, Class<?> cls, Class<T> componentClass, Type componentType) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                ArrayList<Object> a = new ArrayList<Object>(count);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a.add(unserializer.read(reader, stream, componentClass, componentType));
                }
                stream.read();
                return a;
            }
            case 114: {
                return (ArrayList)reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    static final ArrayList readArrayList(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        Class componentClass;
        Object componentType;
        if (type instanceof ParameterizedType) {
            componentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            componentClass = ClassUtil.toClass((Type)componentType);
        } else {
            componentType = Object.class;
            componentClass = Object.class;
        }
        return ArrayListUnserializer.readArrayList(reader, buffer, cls, componentClass, (Type)componentType);
    }

    static final ArrayList readArrayList(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        Class componentClass;
        Object componentType;
        if (type instanceof ParameterizedType) {
            componentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            componentClass = ClassUtil.toClass((Type)componentType);
        } else {
            componentType = Object.class;
            componentClass = Object.class;
        }
        return ArrayListUnserializer.readArrayList(reader, stream, cls, componentClass, (Type)componentType);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ArrayListUnserializer.readArrayList(reader, buffer, cls, type);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ArrayListUnserializer.readArrayList(reader, stream, cls, type);
    }
}

