/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.UnserializerFactory;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ArrayUnserializer
implements Unserializer {
    public static final ArrayUnserializer instance = new ArrayUnserializer();

    ArrayUnserializer() {
    }

    static final <T> T[] readArray(Reader reader, ByteBuffer buffer, Class<T> componentClass, Type componentType) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                Object[] a = (Object[])Array.newInstance(componentClass, count);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a[i] = unserializer.read(reader, buffer, componentClass, componentType);
                }
                buffer.get();
                return a;
            }
            case 114: {
                return (Object[])reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.newInstance(componentClass, 0).getClass());
    }

    static final <T> T[] readArray(Reader reader, InputStream stream, Class<T> componentClass, Type componentType) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                Object[] a = (Object[])Array.newInstance(componentClass, count);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a[i] = unserializer.read(reader, stream, componentClass, componentType);
                }
                stream.read();
                return a;
            }
            case 114: {
                return (Object[])reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.newInstance(componentClass, 0).getClass());
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        Class<?> componentClass = cls.getComponentType();
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return ArrayUnserializer.readArray(reader, buffer, componentClass, componentType);
        }
        return ArrayUnserializer.readArray(reader, buffer, componentClass, componentClass);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        Class<?> componentClass = cls.getComponentType();
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            return ArrayUnserializer.readArray(reader, stream, componentClass, componentType);
        }
        return ArrayUnserializer.readArray(reader, stream, componentClass, componentClass);
    }
}

