/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BigDecimalUnserializer
implements Unserializer {
    public static final BigDecimalUnserializer instance = new BigDecimalUnserializer();

    BigDecimalUnserializer() {
    }

    static final BigDecimal read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 100) {
            return new BigDecimal(ValueReader.readUntil(buffer, 59).toString());
        }
        if (tag == 110) {
            return null;
        }
        if (tag == 108) {
            return new BigDecimal(ValueReader.readLong(buffer));
        }
        if (tag == 105) {
            return new BigDecimal(ValueReader.readInt(buffer));
        }
        if (tag >= 48 && tag <= 57) {
            return BigDecimal.valueOf(tag - 48);
        }
        switch (tag) {
            case 101: {
                return BigDecimal.ZERO;
            }
            case 116: {
                return BigDecimal.ONE;
            }
            case 102: {
                return BigDecimal.ZERO;
            }
            case 117: {
                return new BigDecimal(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return new BigDecimal(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return new BigDecimal(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), BigDecimal.class);
    }

    static final BigDecimal read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 100) {
            return new BigDecimal(ValueReader.readUntil(stream, 59).toString());
        }
        if (tag == 110) {
            return null;
        }
        if (tag == 108) {
            return new BigDecimal(ValueReader.readLong(stream));
        }
        if (tag == 105) {
            return new BigDecimal(ValueReader.readInt(stream));
        }
        if (tag >= 48 && tag <= 57) {
            return BigDecimal.valueOf(tag - 48);
        }
        switch (tag) {
            case 101: {
                return BigDecimal.ZERO;
            }
            case 116: {
                return BigDecimal.ONE;
            }
            case 102: {
                return BigDecimal.ZERO;
            }
            case 117: {
                return new BigDecimal(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return new BigDecimal(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return new BigDecimal(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), BigDecimal.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return BigDecimalUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return BigDecimalUnserializer.read(reader, stream);
    }
}

