/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BigIntegerUnserializer
implements Unserializer {
    public static final BigIntegerUnserializer instance = new BigIntegerUnserializer();

    BigIntegerUnserializer() {
    }

    static final BigInteger read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 108) {
            ValueReader.readBigInteger(buffer);
        }
        if (tag == 110) {
            return null;
        }
        if (tag == 105) {
            return BigInteger.valueOf(ValueReader.readInt(buffer));
        }
        if (tag >= 48 && tag <= 57) {
            return BigInteger.valueOf(tag - 48);
        }
        switch (tag) {
            case 100: {
                return BigInteger.valueOf(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
            case 101: {
                return BigInteger.ZERO;
            }
            case 116: {
                return BigInteger.ONE;
            }
            case 102: {
                return BigInteger.ZERO;
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toBigInteger();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toBigInteger();
            }
            case 117: {
                return new BigInteger(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return new BigInteger(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return new BigInteger(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), BigInteger.class);
    }

    static final BigInteger read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 108) {
            ValueReader.readBigInteger(stream);
        }
        if (tag == 110) {
            return null;
        }
        if (tag == 105) {
            return BigInteger.valueOf(ValueReader.readInt(stream));
        }
        if (tag >= 48 && tag <= 57) {
            return BigInteger.valueOf(tag - 48);
        }
        switch (tag) {
            case 100: {
                return BigInteger.valueOf(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
            case 101: {
                return BigInteger.ZERO;
            }
            case 116: {
                return BigInteger.ONE;
            }
            case 102: {
                return BigInteger.ZERO;
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toBigInteger();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toBigInteger();
            }
            case 117: {
                return new BigInteger(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return new BigInteger(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return new BigInteger(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), BigInteger.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return BigIntegerUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return BigIntegerUnserializer.read(reader, stream);
    }
}

