/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigInteger;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BooleanUnserializer
implements Unserializer {
    public static final BooleanUnserializer instance = new BooleanUnserializer();

    static final boolean read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 48: {
                return false;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
            case 105: {
                return ValueReader.readInt(buffer) != 0;
            }
            case 108: {
                return !BigInteger.ZERO.equals(ValueReader.readBigInteger(buffer));
            }
            case 100: {
                return ValueReader.readDouble(buffer) != 0.0;
            }
            case 101: {
                return false;
            }
            case 78: {
                return true;
            }
            case 73: {
                buffer.get();
                return true;
            }
            case 117: {
                return "\u0000".indexOf(ValueReader.readChar(buffer)) == -1;
            }
            case 115: {
                return Boolean.parseBoolean(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return Boolean.parseBoolean(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Boolean.TYPE);
    }

    static final boolean read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 48: {
                return false;
            }
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return true;
            }
            case 105: {
                return ValueReader.readInt(stream) != 0;
            }
            case 108: {
                return !BigInteger.ZERO.equals(ValueReader.readBigInteger(stream));
            }
            case 100: {
                return ValueReader.readDouble(stream) != 0.0;
            }
            case 101: {
                return false;
            }
            case 78: {
                return true;
            }
            case 73: {
                stream.read();
                return true;
            }
            case 117: {
                return "\u0000".indexOf(ValueReader.readChar(stream)) == -1;
            }
            case 115: {
                return Boolean.parseBoolean(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return Boolean.parseBoolean(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Boolean.TYPE);
    }

    public static final boolean read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 116: {
                return true;
            }
            case 102: 
            case 110: {
                return false;
            }
        }
        return BooleanUnserializer.read(reader, buffer, (int)tag);
    }

    public static final boolean read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 116: {
                return true;
            }
            case 102: 
            case 110: {
                return false;
            }
        }
        return BooleanUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return BooleanUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return BooleanUnserializer.read(reader, stream);
    }
}

