/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.ByteUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ByteArrayUnserializer
implements Unserializer {
    public static final ByteArrayUnserializer instance = new ByteArrayUnserializer();

    ByteArrayUnserializer() {
    }

    static final byte[] readBytes(Reader reader, ByteBuffer buffer) throws IOException {
        byte[] b = ValueReader.readBytes(buffer);
        reader.refer.set(b);
        return b;
    }

    static final byte[] readBytes(Reader reader, InputStream stream) throws IOException {
        byte[] b = ValueReader.readBytes(stream);
        reader.refer.set(b);
        return b;
    }

    static final byte[] read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 98) {
            return ByteArrayUnserializer.readBytes(reader, buffer);
        }
        switch (tag) {
            case 110: {
                return null;
            }
            case 101: {
                return new byte[0];
            }
            case 117: {
                return ValueReader.readUTF8Char(buffer).getBytes("UTF-8");
            }
            case 115: {
                return StringUnserializer.readString(reader, buffer).getBytes("UTF-8");
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                byte[] a = new byte[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = ByteUnserializer.read(reader, buffer);
                }
                buffer.get();
                return a;
            }
            case 114: {
                Object obj = reader.readRef(buffer);
                if (obj instanceof byte[]) {
                    return (byte[])obj;
                }
                if (obj instanceof String) {
                    return ((String)obj).getBytes("UTF-8");
                }
                throw ValueReader.castError(obj, Array.class);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    static final byte[] read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 98) {
            return ByteArrayUnserializer.readBytes(reader, stream);
        }
        switch (tag) {
            case 110: {
                return null;
            }
            case 101: {
                return new byte[0];
            }
            case 117: {
                return ValueReader.readUTF8Char(stream).getBytes("UTF-8");
            }
            case 115: {
                return StringUnserializer.readString(reader, stream).getBytes("UTF-8");
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                byte[] a = new byte[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = ByteUnserializer.read(reader, stream);
                }
                stream.read();
                return a;
            }
            case 114: {
                Object obj = reader.readRef(stream);
                if (obj instanceof byte[]) {
                    return (byte[])obj;
                }
                if (obj instanceof String) {
                    return ((String)obj).getBytes("UTF-8");
                }
                throw ValueReader.castError(obj, Array.class);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return ByteArrayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return ByteArrayUnserializer.read(reader, stream);
    }
}

