/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.CalendarUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarArrayUnserializer
implements Unserializer {
    public static final CalendarArrayUnserializer instance = new CalendarArrayUnserializer();

    CalendarArrayUnserializer() {
    }

    static final Calendar[] read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                Calendar[] a = new Calendar[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = CalendarUnserializer.read(reader, buffer);
                }
                buffer.get();
                return a;
            }
            case 114: {
                return (Calendar[])reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    static final Calendar[] read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                Calendar[] a = new Calendar[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = CalendarUnserializer.read(reader, stream);
                }
                stream.read();
                return a;
            }
            case 114: {
                return (Calendar[])reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return CalendarArrayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return CalendarArrayUnserializer.read(reader, stream);
    }
}

