/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Calendar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CalendarUnserializer
implements Unserializer {
    public static final CalendarUnserializer instance = new CalendarUnserializer();

    CalendarUnserializer() {
    }

    private static Calendar toCalendar(Object obj) throws HproseException {
        if (obj instanceof DateTime) {
            return ((DateTime)obj).toCalendar();
        }
        throw ValueReader.castError(obj, Calendar.class);
    }

    private static Calendar toCalendar(int tag) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(tag - 48);
        return calendar;
    }

    static final Calendar read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toCalendar();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toCalendar();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return CalendarUnserializer.toCalendar(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return CalendarUnserializer.toCalendar(tag);
        }
        switch (tag) {
            case 105: 
            case 108: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(ValueReader.readLong(buffer));
                return calendar;
            }
            case 100: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
                return calendar;
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Calendar.class);
    }

    static final Calendar read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toCalendar();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toCalendar();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return CalendarUnserializer.toCalendar(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return CalendarUnserializer.toCalendar(tag);
        }
        switch (tag) {
            case 105: 
            case 108: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(ValueReader.readLong(stream));
                return calendar;
            }
            case 100: {
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(Double.valueOf(ValueReader.readDouble(stream)).longValue());
                return calendar;
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Calendar.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return CalendarUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return CalendarUnserializer.read(reader, stream);
    }
}

