/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.CharUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CharArrayUnserializer
implements Unserializer {
    public static final CharArrayUnserializer instance = new CharArrayUnserializer();

    CharArrayUnserializer() {
    }

    static final char[] readChars(Reader reader, ByteBuffer buffer) throws IOException {
        char[] chars = ValueReader.readChars(buffer);
        reader.refer.set(chars);
        return chars;
    }

    static final char[] readChars(Reader reader, InputStream stream) throws IOException {
        char[] chars = ValueReader.readChars(stream);
        reader.refer.set(chars);
        return chars;
    }

    static final char[] read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 117: {
                return new char[]{ValueReader.readChar(buffer)};
            }
            case 115: {
                return CharArrayUnserializer.readChars(reader, buffer);
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                char[] a = new char[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = CharUnserializer.read(reader, buffer);
                }
                buffer.get();
                return a;
            }
            case 114: {
                Object obj = reader.readRef(buffer);
                if (obj instanceof char[]) {
                    return (char[])obj;
                }
                if (obj instanceof String) {
                    return ((String)obj).toCharArray();
                }
                throw ValueReader.castError(obj, Array.class);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    static final char[] read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 117: {
                return new char[]{ValueReader.readChar(stream)};
            }
            case 115: {
                return CharArrayUnserializer.readChars(reader, stream);
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                char[] a = new char[count];
                reader.refer.set(a);
                for (int i = 0; i < count; ++i) {
                    a[i] = CharUnserializer.read(reader, stream);
                }
                stream.read();
                return a;
            }
            case 114: {
                Object obj = reader.readRef(stream);
                if (obj instanceof char[]) {
                    return (char[])obj;
                }
                if (obj instanceof String) {
                    return ((String)obj).toCharArray();
                }
                throw ValueReader.castError(obj, Array.class);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Array.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return CharArrayUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return CharArrayUnserializer.read(reader, stream);
    }
}

