/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CharUnserializer
implements Unserializer {
    public static final CharUnserializer instance = new CharUnserializer();

    static final char read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return (char)tag;
            }
            case 105: {
                return (char)ValueReader.readInt(buffer);
            }
            case 108: {
                return (char)ValueReader.readLong(buffer);
            }
            case 100: {
                return (char)Double.valueOf(ValueReader.readDouble(buffer)).intValue();
            }
            case 115: {
                return StringUnserializer.readString(reader, buffer).charAt(0);
            }
            case 114: {
                return reader.readRef(buffer, String.class).charAt(0);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Character.TYPE);
    }

    static final char read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return (char)tag;
            }
            case 105: {
                return (char)ValueReader.readInt(stream);
            }
            case 108: {
                return (char)ValueReader.readLong(stream);
            }
            case 100: {
                return (char)Double.valueOf(ValueReader.readDouble(stream)).intValue();
            }
            case 117: {
                return ValueReader.readChar(stream);
            }
            case 115: {
                return StringUnserializer.readString(reader, stream).charAt(0);
            }
            case 114: {
                return reader.readRef(stream, String.class).charAt(0);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Character.TYPE);
    }

    public static final char read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 117) {
            return ValueReader.readChar(buffer);
        }
        if (tag == 110) {
            return '\u0000';
        }
        return CharUnserializer.read(reader, buffer, (int)tag);
    }

    public static final char read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 117) {
            return ValueReader.readChar(stream);
        }
        if (tag == 110) {
            return '\u0000';
        }
        return CharUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return Character.valueOf(CharUnserializer.read(reader, buffer));
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return Character.valueOf(CharUnserializer.read(reader, stream));
    }
}

