/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.accessor.ConstructorAccessor;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.UnserializerFactory;
import hprose.io.unserialize.ValueReader;
import hprose.util.ClassUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class CollectionUnserializer
implements Unserializer {
    public static final CollectionUnserializer instance = new CollectionUnserializer();

    CollectionUnserializer() {
    }

    private static <T> Collection<T> readCollection(Reader reader, ByteBuffer buffer, Class<?> cls, Class<T> componentClass, Type componentType) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(buffer, 123);
                Collection a = (Collection)ConstructorAccessor.newInstance(cls);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a.add(unserializer.read(reader, buffer, componentClass, componentType));
                }
                buffer.get();
                return a;
            }
            case 114: {
                return (Collection)reader.readRef(buffer);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    private static <T> Collection<T> readCollection(Reader reader, InputStream stream, Class<?> cls, Class<T> componentClass, Type componentType) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 110: {
                return null;
            }
            case 97: {
                int count = ValueReader.readInt(stream, 123);
                Collection a = (Collection)ConstructorAccessor.newInstance(cls);
                reader.refer.set(a);
                Unserializer unserializer = UnserializerFactory.get(componentClass);
                for (int i = 0; i < count; ++i) {
                    a.add(unserializer.read(reader, stream, componentClass, componentType));
                }
                stream.read();
                return a;
            }
            case 114: {
                return (Collection)reader.readRef(stream);
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), cls);
    }

    static final Collection readCollection(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        Class componentClass;
        Object componentType;
        if (type instanceof ParameterizedType) {
            componentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            componentClass = ClassUtil.toClass((Type)componentType);
        } else {
            componentType = Object.class;
            componentClass = Object.class;
        }
        return CollectionUnserializer.readCollection(reader, buffer, cls, componentClass, (Type)componentType);
    }

    static final Collection readCollection(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        Class componentClass;
        Object componentType;
        if (type instanceof ParameterizedType) {
            componentType = ((ParameterizedType)type).getActualTypeArguments()[0];
            componentClass = ClassUtil.toClass((Type)componentType);
        } else {
            componentType = Object.class;
            componentClass = Object.class;
        }
        return CollectionUnserializer.readCollection(reader, stream, cls, componentClass, (Type)componentType);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        if (!Modifier.isInterface(cls.getModifiers()) && !Modifier.isAbstract(cls.getModifiers())) {
            return CollectionUnserializer.readCollection(reader, buffer, cls, type);
        }
        throw new HproseException(type.toString() + " is not an instantiable class.");
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        if (!Modifier.isInterface(cls.getModifiers()) && !Modifier.isAbstract(cls.getModifiers())) {
            return CollectionUnserializer.readCollection(reader, stream, cls, type);
        }
        throw new HproseException(type.toString() + " is not an instantiable class.");
    }
}

