/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DefaultUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.sql.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DateUnserializer
implements Unserializer {
    public static final DateUnserializer instance = new DateUnserializer();

    DateUnserializer() {
    }

    private static Date toDate(Object obj) {
        if (obj instanceof DateTime) {
            return ((DateTime)obj).toDate();
        }
        if (obj instanceof char[]) {
            return Date.valueOf(new String((char[])obj));
        }
        return Date.valueOf(obj.toString());
    }

    static final Date read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toDate();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toDate();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Date.valueOf(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return DateUnserializer.toDate(reader.readRef(buffer));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Date(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Date(ValueReader.readLong(buffer));
            }
            case 100: {
                return new Date(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Date.class);
    }

    static final Date read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        switch (tag) {
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toDate();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toDate();
            }
            case 101: 
            case 110: {
                return null;
            }
            case 115: {
                return Date.valueOf(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return DateUnserializer.toDate(reader.readRef(stream));
            }
        }
        if (tag >= 48 && tag <= 57) {
            return new Date(tag - 48);
        }
        switch (tag) {
            case 105: 
            case 108: {
                return new Date(ValueReader.readLong(stream));
            }
            case 100: {
                return new Date(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Date.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return DateUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return DateUnserializer.read(reader, stream);
    }
}

