/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.common.HproseException;
import hprose.io.unserialize.ByteArrayUnserializer;
import hprose.io.unserialize.ObjectUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.UUIDUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import hprose.util.DateTime;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DefaultUnserializer
implements Unserializer {
    public static final DefaultUnserializer instance = new DefaultUnserializer();

    DefaultUnserializer() {
    }

    static final DateTime readDateTime(Reader reader, ByteBuffer buffer) throws IOException {
        DateTime datetime = ValueReader.readDateTime(buffer);
        reader.refer.set(datetime);
        return datetime;
    }

    static final DateTime readDateTime(Reader reader, InputStream stream) throws IOException {
        DateTime datetime = ValueReader.readDateTime(stream);
        reader.refer.set(datetime);
        return datetime;
    }

    static final DateTime readTime(Reader reader, ByteBuffer buffer) throws IOException {
        DateTime datetime = ValueReader.readTime(buffer);
        reader.refer.set(datetime);
        return datetime;
    }

    static final DateTime readTime(Reader reader, InputStream stream) throws IOException {
        DateTime datetime = ValueReader.readTime(stream);
        reader.refer.set(datetime);
        return datetime;
    }

    static final ArrayList readList(Reader reader, ByteBuffer buffer) throws IOException {
        int count = ValueReader.readInt(buffer, 123);
        ArrayList<Object> a = new ArrayList<Object>(count);
        reader.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a.add(DefaultUnserializer.read(reader, buffer));
        }
        buffer.get();
        return a;
    }

    static final ArrayList readList(Reader reader, InputStream stream) throws IOException {
        int count = ValueReader.readInt(stream, 123);
        ArrayList<Object> a = new ArrayList<Object>(count);
        reader.refer.set(a);
        for (int i = 0; i < count; ++i) {
            a.add(DefaultUnserializer.read(reader, stream));
        }
        stream.read();
        return a;
    }

    static final HashMap readMap(Reader reader, ByteBuffer buffer) throws IOException {
        int count = ValueReader.readInt(buffer, 123);
        HashMap<Object, Object> map = new HashMap<Object, Object>(count);
        reader.refer.set(map);
        for (int i = 0; i < count; ++i) {
            Object key = DefaultUnserializer.read(reader, buffer);
            Object value = DefaultUnserializer.read(reader, buffer);
            map.put(key, value);
        }
        buffer.get();
        return map;
    }

    static final HashMap readMap(Reader reader, InputStream stream) throws IOException {
        int count = ValueReader.readInt(stream, 123);
        HashMap<Object, Object> map = new HashMap<Object, Object>(count);
        reader.refer.set(map);
        for (int i = 0; i < count; ++i) {
            Object key = DefaultUnserializer.read(reader, stream);
            Object value = DefaultUnserializer.read(reader, stream);
            map.put(key, value);
        }
        stream.read();
        return map;
    }

    static final Object read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 105: {
                return ValueReader.readInt(buffer);
            }
            case 108: {
                return ValueReader.readBigInteger(buffer);
            }
            case 100: {
                return ValueReader.readDouble(buffer);
            }
            case 110: {
                return null;
            }
            case 101: {
                return "";
            }
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
            case 78: {
                return Double.NaN;
            }
            case 73: {
                return ValueReader.readInfinity(buffer);
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, buffer).toCalendar();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, buffer).toCalendar();
            }
            case 98: {
                return ByteArrayUnserializer.readBytes(reader, buffer);
            }
            case 117: {
                return ValueReader.readUTF8Char(buffer);
            }
            case 115: {
                return StringUnserializer.readString(reader, buffer);
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, buffer);
            }
            case 97: {
                return DefaultUnserializer.readList(reader, buffer);
            }
            case 109: {
                return DefaultUnserializer.readMap(reader, buffer);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, buffer);
                return ObjectUnserializer.read(reader, buffer, null);
            }
            case 111: {
                return ObjectUnserializer.readObject(reader, buffer, null);
            }
            case 114: {
                return reader.readRef(buffer);
            }
            case 69: {
                throw new HproseException(StringUnserializer.read(reader, buffer));
            }
        }
        throw reader.unexpectedTag(tag);
    }

    static final Object read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 48: {
                return 0;
            }
            case 49: {
                return 1;
            }
            case 50: {
                return 2;
            }
            case 51: {
                return 3;
            }
            case 52: {
                return 4;
            }
            case 53: {
                return 5;
            }
            case 54: {
                return 6;
            }
            case 55: {
                return 7;
            }
            case 56: {
                return 8;
            }
            case 57: {
                return 9;
            }
            case 105: {
                return ValueReader.readInt(stream);
            }
            case 108: {
                return ValueReader.readBigInteger(stream);
            }
            case 100: {
                return ValueReader.readDouble(stream);
            }
            case 110: {
                return null;
            }
            case 101: {
                return "";
            }
            case 116: {
                return true;
            }
            case 102: {
                return false;
            }
            case 78: {
                return Double.NaN;
            }
            case 73: {
                return ValueReader.readInfinity(stream);
            }
            case 68: {
                return DefaultUnserializer.readDateTime(reader, stream).toCalendar();
            }
            case 84: {
                return DefaultUnserializer.readTime(reader, stream).toCalendar();
            }
            case 98: {
                return ByteArrayUnserializer.readBytes(reader, stream);
            }
            case 117: {
                return ValueReader.readUTF8Char(stream);
            }
            case 115: {
                return StringUnserializer.readString(reader, stream);
            }
            case 103: {
                return UUIDUnserializer.readUUID(reader, stream);
            }
            case 97: {
                return DefaultUnserializer.readList(reader, stream);
            }
            case 109: {
                return DefaultUnserializer.readMap(reader, stream);
            }
            case 99: {
                ObjectUnserializer.readClass(reader, stream);
                return ObjectUnserializer.read(reader, stream, null);
            }
            case 111: {
                return ObjectUnserializer.readObject(reader, stream, null);
            }
            case 114: {
                return reader.readRef(stream);
            }
            case 69: {
                throw new HproseException(StringUnserializer.read(reader, stream));
            }
        }
        throw reader.unexpectedTag(tag);
    }

    static final Object read(Reader reader, ByteBuffer buffer) throws IOException {
        return DefaultUnserializer.read(reader, buffer, (int)buffer.get());
    }

    static final Object read(Reader reader, InputStream stream) throws IOException {
        return DefaultUnserializer.read(reader, stream, stream.read());
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return DefaultUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return DefaultUnserializer.read(reader, stream);
    }
}

