/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.DoubleUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DoubleObjectUnserializer
implements Unserializer {
    public static final DoubleObjectUnserializer instance = new DoubleObjectUnserializer();

    DoubleObjectUnserializer() {
    }

    static final Double read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 100) {
            return ValueReader.readDouble(buffer);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(buffer, 59);
        }
        if (tag == 110) {
            return null;
        }
        return DoubleUnserializer.read(reader, buffer, (int)tag);
    }

    static final Double read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 100) {
            return ValueReader.readDouble(stream);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(stream, 59);
        }
        if (tag == 110) {
            return null;
        }
        return DoubleUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return DoubleObjectUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return DoubleObjectUnserializer.read(reader, stream);
    }
}

