/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DoubleUnserializer
implements Unserializer {
    public static final DoubleUnserializer instance = new DoubleUnserializer();

    static final double read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readLongAsDouble(buffer);
            }
            case 101: {
                return 0.0;
            }
            case 116: {
                return 1.0;
            }
            case 102: {
                return 0.0;
            }
            case 78: {
                return Double.NaN;
            }
            case 73: {
                return ValueReader.readInfinity(buffer);
            }
            case 117: {
                return ValueReader.parseDouble(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return ValueReader.parseDouble(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return ValueReader.parseDouble(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Double.TYPE);
    }

    static final double read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readLongAsDouble(stream);
            }
            case 101: {
                return 0.0;
            }
            case 116: {
                return 1.0;
            }
            case 102: {
                return 0.0;
            }
            case 78: {
                return Double.NaN;
            }
            case 73: {
                return ValueReader.readInfinity(stream);
            }
            case 117: {
                return ValueReader.parseDouble(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return ValueReader.parseDouble(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return ValueReader.parseDouble(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Double.TYPE);
    }

    public static final double read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 100) {
            return ValueReader.readDouble(buffer);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(buffer, 59);
        }
        if (tag == 110) {
            return 0.0;
        }
        return DoubleUnserializer.read(reader, buffer, (int)tag);
    }

    public static final double read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 100) {
            return ValueReader.readDouble(stream);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(stream, 59);
        }
        if (tag == 110) {
            return 0.0;
        }
        return DoubleUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return DoubleUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return DoubleUnserializer.read(reader, stream);
    }
}

