/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.time.Duration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DurationUnserializer
implements Unserializer {
    public static final DurationUnserializer instance = new DurationUnserializer();

    DurationUnserializer() {
    }

    private static Duration toDuration(Object obj) {
        if (obj instanceof char[]) {
            return Duration.parse(new String((char[])obj));
        }
        return Duration.parse(obj.toString());
    }

    static final Duration read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag >= 48 && tag <= 57) {
            return Duration.ofNanos(tag - 48);
        }
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return DurationUnserializer.toDuration(reader.readRef(buffer));
            }
            case 105: 
            case 108: {
                return Duration.ofNanos(ValueReader.readLong(buffer));
            }
            case 100: {
                return Duration.ofNanos(Double.valueOf(ValueReader.readDouble(buffer)).longValue());
            }
            case 115: {
                return Duration.parse(StringUnserializer.readString(reader, buffer));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Duration.class);
    }

    static final Duration read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag >= 48 && tag <= 57) {
            return Duration.ofNanos(tag - 48);
        }
        switch (tag) {
            case 101: 
            case 110: {
                return null;
            }
            case 114: {
                return DurationUnserializer.toDuration(reader.readRef(stream));
            }
            case 105: 
            case 108: {
                return Duration.ofNanos(ValueReader.readLong(stream));
            }
            case 100: {
                return Duration.ofNanos(Double.valueOf(ValueReader.readDouble(stream)).longValue());
            }
            case 115: {
                return Duration.parse(StringUnserializer.readString(reader, stream));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Duration.class);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return DurationUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return DurationUnserializer.read(reader, stream);
    }
}

