/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.FloatUnserializer;
import hprose.io.unserialize.Reader;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FloatObjectUnserializer
implements Unserializer {
    public static final FloatObjectUnserializer instance = new FloatObjectUnserializer();

    FloatObjectUnserializer() {
    }

    static final Float read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 100) {
            return Float.valueOf(ValueReader.readFloat(buffer));
        }
        if (tag >= 48 && tag <= 57) {
            return Float.valueOf(tag - 48);
        }
        if (tag == 105) {
            return Float.valueOf(ValueReader.readInt(buffer, 59));
        }
        if (tag == 110) {
            return null;
        }
        return Float.valueOf(FloatUnserializer.read(reader, buffer, (int)tag));
    }

    static final Float read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 100) {
            return Float.valueOf(ValueReader.readFloat(stream));
        }
        if (tag >= 48 && tag <= 57) {
            return Float.valueOf(tag - 48);
        }
        if (tag == 105) {
            return Float.valueOf(ValueReader.readInt(stream, 59));
        }
        if (tag == 110) {
            return null;
        }
        return Float.valueOf(FloatUnserializer.read(reader, stream, tag));
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return FloatObjectUnserializer.read(reader, buffer);
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return FloatObjectUnserializer.read(reader, stream);
    }
}

