/*
 * Decompiled with CFR 0.152.
 */
package hprose.io.unserialize;

import hprose.io.unserialize.Reader;
import hprose.io.unserialize.StringUnserializer;
import hprose.io.unserialize.Unserializer;
import hprose.io.unserialize.ValueReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FloatUnserializer
implements Unserializer {
    public static final FloatUnserializer instance = new FloatUnserializer();

    static final float read(Reader reader, ByteBuffer buffer, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readLongAsFloat(buffer);
            }
            case 101: {
                return 0.0f;
            }
            case 116: {
                return 1.0f;
            }
            case 102: {
                return 0.0f;
            }
            case 78: {
                return Float.NaN;
            }
            case 73: {
                return buffer.get() == 43 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            case 117: {
                return ValueReader.parseFloat(ValueReader.readUTF8Char(buffer));
            }
            case 115: {
                return ValueReader.parseFloat(StringUnserializer.readString(reader, buffer));
            }
            case 114: {
                return ValueReader.parseFloat(reader.readRef(buffer, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Float.TYPE);
    }

    static final float read(Reader reader, InputStream stream, int tag) throws IOException {
        switch (tag) {
            case 108: {
                return ValueReader.readLongAsFloat(stream);
            }
            case 101: {
                return 0.0f;
            }
            case 116: {
                return 1.0f;
            }
            case 102: {
                return 0.0f;
            }
            case 78: {
                return Float.NaN;
            }
            case 73: {
                return stream.read() == 43 ? Float.POSITIVE_INFINITY : Float.NEGATIVE_INFINITY;
            }
            case 117: {
                return ValueReader.parseFloat(ValueReader.readUTF8Char(stream));
            }
            case 115: {
                return ValueReader.parseFloat(StringUnserializer.readString(reader, stream));
            }
            case 114: {
                return ValueReader.parseFloat(reader.readRef(stream, String.class));
            }
        }
        throw ValueReader.castError(reader.tagToString(tag), Float.TYPE);
    }

    public static final float read(Reader reader, ByteBuffer buffer) throws IOException {
        byte tag = buffer.get();
        if (tag == 100) {
            return ValueReader.readFloat(buffer);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(buffer, 59);
        }
        if (tag == 110) {
            return 0.0f;
        }
        return FloatUnserializer.read(reader, buffer, (int)tag);
    }

    public static final float read(Reader reader, InputStream stream) throws IOException {
        int tag = stream.read();
        if (tag == 100) {
            return ValueReader.readFloat(stream);
        }
        if (tag >= 48 && tag <= 57) {
            return tag - 48;
        }
        if (tag == 105) {
            return ValueReader.readInt(stream, 59);
        }
        if (tag == 110) {
            return 0.0f;
        }
        return FloatUnserializer.read(reader, stream, tag);
    }

    @Override
    public final Object read(Reader reader, ByteBuffer buffer, Class<?> cls, Type type) throws IOException {
        return Float.valueOf(FloatUnserializer.read(reader, buffer));
    }

    @Override
    public final Object read(Reader reader, InputStream stream, Class<?> cls, Type type) throws IOException {
        return Float.valueOf(FloatUnserializer.read(reader, stream));
    }
}

